
/************************************************************************/
/*									*/
/*			Malloc Macro definitions			*/
/*									*/
/************************************************************************/

#define OsAllocPgen(ptr,size,type)	ptr = (type *) OsAlloc(size)
#define OsFreePgen(ptr,size)		OsFree(ptr)

#define Malloc_PriorityVec(p,SIZE)  OsAllocPgen(p,sizeof(PVECTOR)*SIZE,PVECTOR)
#define Free_PriorityVec(ptr,size)  	    OsFreePgen(ptr,size)

#define PGEN_COPY_VECTOR(vector1_ptr, vector2_ptr)\
{\
	PVECTOR		*p_ptr, *c_ptr;\
	int		vector1_size;\
\
	p_ptr = vector1_ptr;\
	c_ptr = vector2_ptr;\
	if ( (*p_ptr >> 24) > 24 )\
		vector1_size = ( ((*p_ptr >> 24) - 25) >> 5 )  + 2;\
	else\
		vector1_size = 1;\
\
        for (;p_ptr < vector1_ptr+vector1_size; p_ptr++,c_ptr++)\
		*c_ptr = *p_ptr;\
}

#define PGEN_VECTOR_SIZE(size,length)\
{\
	if ( length > 24 )\
		size = ( (length - 25) >> 5 )  + 2;\
	else\
		size = 1;\
}

#define PGEN_GET_PVECTOR2(ptr1,ptr1_length,ptr2,ptr2_length,ptr2_rel_prio)\
{\
	LONG	branch_bits;\
	PVECTOR	*p_ptr, *c_ptr;\
	SHORT	ptr1_size, ptr2_size;\
	int	shift;\
\
	   if ( ptr1_length > 24)\
		ptr1_size = ( (ptr1_length - 25) >> 5 )  + 2;\
	   else\
		ptr1_size = 1;\
\
	   if ( ptr2_length > 24)\
		ptr2_size = ( (ptr2_length - 25) >> 5 )  + 2;\
	   else\
		ptr2_size = 1;\
\
	   Malloc_PriorityVec(ptr2,ptr2_size);\
	   branch_bits = ptr2_length - ptr1_length;\
	   p_ptr = ptr1;\
	   c_ptr = ptr2;\
	   for(;p_ptr < ptr1+ptr1_size; p_ptr++,c_ptr++)\
		*c_ptr = *p_ptr;\
	   c_ptr = ptr2;\
	   *ptr2 = (*ptr2 & 0x0ffffff) | ((ptr2_length & 0x0ff) << 24 );\
\
	if ( ptr2_rel_prio > 0 )\
	{\
	   if  ( ptr1_size == 1 )\
	   {\
	     if ( ptr2_size == ptr1_size )\
	     {\
		/* modify the first word of the child bit vector */\
		*ptr2 = *ptr2 | (ptr2_rel_prio << (24-ptr2_length) );\
	   	ptr2 = c_ptr;\
	     }\
	     else\
	     {\
		/* if the parent bit vector is on a word boundry */\
		if ( ((ptr1_length + 8) % 32) == 0)\
		{\
		   /* set child ptr to the last word of the child vector */\
		   ptr2 = ptr2 + (ptr2_size - 1);\
		   /* append the child priority to that word */\
		   *ptr2 = (ptr2_rel_prio << (32-branch_bits));\
	   	ptr2 = c_ptr;\
		}/* ptr1_length +8 % 32 == 0 */\
		else\
		{ /* if the parent bit vector is NOT on a word boundry */\
		      /*append the child priority to the child word */\
		   *ptr2 = *ptr2\
		    | (ptr2_rel_prio >> (branch_bits-(24-ptr1_length)) );\
		   /* go to the next word */\
		   ptr2++;\
		   /* append the remaining priority bits to the next\
			child bit vector*/\
		   *ptr2 = ptr2_rel_prio << (32-(branch_bits-(24-ptr1_size)));\
	   	ptr2 = c_ptr;\
		}/* ptr1_length +8 % 32 != 0 */\
	     }\
	   }\
	   else\
	   {\
	     if (ptr2_size == ptr1_size)\
	     {\
		/* set child ptr to the last word of the child vector */\
		ptr2 = ptr2 + ptr2_size - 1;\
		shift = 32 - ((ptr1_length - 24) % 32) - branch_bits;\
		/* modify the last word of the child bit vector */\
		*ptr2 = *ptr2 | (ptr2_rel_prio << shift );\
	   	ptr2 = c_ptr;\
	     }\
	     else\
	     {\
		/* if the parent bit vector is on a word boundry */\
		if ( ((ptr1_length + 8) % 32) == 0)\
		{\
		   /* set child ptr to the last word of the child vector */\
		   ptr2 = ptr2 + ptr2_size - 1;\
		   /* append the child priority to that word */\
		   *ptr2 = (ptr2_rel_prio << (32-branch_bits));\
	   	ptr2 = c_ptr;\
		}/* ptr1_length +8 % 32 == 0 */\
		else\
		{ /* if the parent bit vector is NOT on a word boundry */\
		 /*set child ptr to the last BUT ONE word of the childvector*/\
		   ptr2 = ptr2 + ptr2_size - 2;\
		   shift = branch_bits - ( (ptr1_size * 32 - 8) - ptr1_length);\
		   /*append the child priority to the child word */\
		   *ptr2 = *ptr2 | (ptr2_rel_prio >> shift );\
		   /* go to the next word */\
		   ptr2++;\
		   /* append the remaining priority bits to the next\
			child bit vector*/\
		   *ptr2 = ptr2_rel_prio << (32 - shift);\
	   	   ptr2 = c_ptr;\
		}/* ptr1_length +8 % 32 != 0 */\
	     }\
	   }\
	}\
}


#define	PGEN_UPDATE_LIT_START(query_ptr, nodeNum)\
{\
	/* Increment the literal_start_count for the nodeNum */\
	query_ptr->lit_start_count[nodeNum]++;\
\
	if ( PgenCheckLitPriorityLimit(query_ptr->lit_start_count[nodeNum]) )\
	     query_ptr->lit_start_count[nodeNum] = PgenGetNextLitVector(query_ptr->lit_start_count[nodeNum]);\
}


#define	PGEN_IDENTICAL_PVECTOR(ptrP, new_priority_ptr)\
{\
	   SHORT	ptrP_size;\
\
	   /* get vector size */\
	   PGEN_VECTOR_SIZE(ptrP_size,(*ptrP >> 24))\
\
	   Malloc_PriorityVec(new_priority_ptr, ptrP_size);\
	   /* copy the parent bit vector to child bit vector */\
	   PGEN_COPY_VECTOR(ptrP, new_priority_ptr);\
}
