#define OsPrintf	printf
#define OsPrint		printf

#ifdef SHARED 

#define OsMyPeNum() MyPenum
#define mem_space memSpaces[MyPenum]
#define next_mem next_mems[MyPenum]

#else

#define OsAlloc(n) OsAlloc2(n)

#endif

#define Malloc_ArcTuple(p,n, numlinks)\
	OsAllocTermFunc(n+numlinks+1, &p);\
	p+=numlinks+1

#define ContextTupIndex -1

#define NextTuplePtr(tuple,n) tuple[n-2]   /* note: n is <= 0 */

#define BackPtr(tuple,n) tuple[n-2]   /* note: n is <= 0 */

#define ForwardPtr(tuple,n)  tuple[TUPLESIZE(tuple) + n]

#define Malloc_NodeTuple(p,n,chainnum,bpnum,fpnum)\
{\
        SHORT i;\
	OsAllocTermFunc(n+(bpnum+chainnum+1)+fpnum, &p);\
	p+= bpnum+chainnum+1; \
	/* the chainnum+1 allows it to double up as an arc tuple */\
	/* back pointers are always assigned before use */\
	for(i = 0; i<fpnum; i++)\
	   p[n+i] = 0;\
}


#define Malloc_Real(p) 	  	OsAllocTermFunc(1, &p)
#define Malloc_Slots(p,n)       OsAllocTermFunc(n, &p)
#define Malloc_Block(p,n,T) p = (T *) OsAlloc(sizeof(char)*n)
#define Malloc_Query(p)	  p = (QUERY *) OsAlloc(sizeof(QUERY))
#define Malloc_Gslot(p)	  p = (GOALSLOT *) OsAlloc(sizeof(GOALSLOT))
#define Malloc_Message(p) p = (MESSAGE *) OsAllocMsg(sizeof(MESSAGE))
#define Malloc_Molecule(p) p = (MOLECULE_PTR *) OsAlloc(sizeof(MOLECULE_PTR))

#define Free_Real(ptr)		OsFreeTerm(ptr,1)
#define Free_Slots(ptr,n) 	OsFreeTerm(ptr,n) 

#ifdef SHARED

#define Free_Clause(ptr) 	OsFree(ptr)
#define Free_Block(ptr,n) 	OsFree(ptr)
#define Free_Query(ptr)		OsFree(ptr)
#define Free_Gslot(ptr)		OsFree(ptr)
#define Free_Molecule(ptr)	OsFree(ptr)
#define Free_Message(ptr)	OsFreeMsg(ptr)
#define Free_RespMsg(ptr) 	OsFree(ptr)

#else

#define Free_Real(ptr)		OsFreeTerm(ptr,1)
#define Free_Slots(ptr,n) 	OsFreeTerm(ptr,n) 
#define Free_Clause(ptr) 	OsFree(ptr, sizeof(CLAUSE))
#define Free_Block(ptr,n) 	OsFree(ptr, n)
#define Free_Query(ptr)		OsFree(ptr, sizeof(QUERY) )
#define Free_Gslot(ptr)		OsFree(ptr, sizeof(GOALSLOT))
#define Free_Molecule(ptr)	OsFree(ptr, sizeof(MOLECULE))
#define Free_Message(ptr)	OsFreeMsg(ptr, sizeof(MESSAGE))
#define Free_RespMsg(ptr) 	OsFree(ptr, sizeof(MESSAGE))

#endif

#define SET_P_C_MARKER()	PURE_CODE_MARKER=next_term




/************************************************************************/
/*									*/
/*			Trace macro definition				*/
/*									*/
/************************************************************************/

#define TRACE(x) x
#define TRACE2(x) if (DEBUG2 == TRUE) x





