/**********************UNIFICATION**********************************/

/* Unification routines for the byte code interpreter */

#include "typedefs.h"
#include "macros.c"
#include "be_macros.c"
#include "seq_macros.c"


/* Takes care of unification where term1 and term2 are not necessarily
   functors. It calls Unify as necessary   */

BOOLEAN DoUnification(term1, tuple1, term2, tuple2, thrumolecule)
SLOT *term1;
SLOT *tuple1;
SLOT *term2;
SLOT *tuple2;
BOOLEAN thrumolecule;
{
    BOOLEAN Unify();
    MOLECULE_PTR *molecule;
    
    Deref_Term(term1, tuple1);
    if (TAG_IS_MOLECULE(term1))
    {
	molecule = MOLECULE_ADDRESS(term1);
	term1 = TERMS(molecule);
	tuple1 = TUPLE(molecule);
	thrumolecule |= TRUE;
    }
    Deref_Term(term2, tuple2);
    if (TAG_IS_MOLECULE(term2))
    {
	molecule = MOLECULE_ADDRESS(term2);
	term2 = TERMS(molecule);
	tuple2 = TUPLE(molecule);
	thrumolecule |= TRUE;
    }
    if (TAG_IS_FUNCTOR(term1) && TAG_IS_FUNCTOR(term2))
       return (Unify(term1, tuple1, term2, tuple2, thrumolecule));

    if (TAG_IS_TUPLE_INDEX_1(term1))
    {
	term1 = &tuple1[INDEX(term1)];
	switch (SLOT_TAG(term2))
	{
	case TUPLE_INDEX_1:
	    INSERT_INDEX(term1, INDEX(term2), TUPLE_INDEX_1);
	    break;
	case CLOSED_TERM:
	case FUNCTOR:
	    if ( ARITY_IS_ZERO(term2))
	         COPY_ATOM(term1, term2);
	    else INSERT_ADDRESS(term1, term2);
	    break;
	case MOLECULE:
	    molecule = MOLECULE_ADDRESS(term2);
	    COPY_MOLECULE(term1, term2, molecule);
	    break;
	case INTEGER:
	case REAL:
	    COPY_ATOM(term1, term2);
	    break;
	default:
	    OsPrintf("error! illegal slot_tag in DoUnification\n");
	    exit(1);
	}
	return TRUE;
    }

    if (TAG_IS_TUPLE_INDEX_1(term2))
    {
	term2 = &tuple2[INDEX(term2)];
	switch (SLOT_TAG(term1))
	{
	case CLOSED_TERM:
	case FUNCTOR:
	    if ( ARITY_IS_ZERO(term1))
	         COPY_ATOM(term2, term1);
	    else INSERT_ADDRESS(term2, term1);
	    break;
	case MOLECULE:
	    molecule = MOLECULE_ADDRESS(term1);
	    COPY_MOLECULE(term2, term1, molecule);
	    break;
	case INTEGER:
	case REAL:
	    COPY_ATOM(term2, term1);
	    break;
	default:
	    OsPrintf("error! illegal slot_tag in DoUnification\n");
	    exit(1);
	}
	return TRUE;
    }
    if (TAG_IS_INTEGER(term1) && TAG_IS_INTEGER(term2))
        return (INTVALUE(term1) == INTVALUE(term2));

    if (TAG_IS_REAL(term1) && TAG_IS_REAL(term2))
        return (REALVALUE(term1) == REALVALUE(term2));
    
    return FALSE;     /* if you got this far, unification fails */
}



BOOLEAN Unify(pterms, ptuple, cterms, ctuple, thrumolecule)
SLOT *pterms;
SLOT *ptuple;
SLOT *cterms;
SLOT *ctuple;
BOOLEAN thrumolecule;

{ 
    SHORT i;
    SHORT  arity, index;
    BOOLEAN pdone, cdone;
    MOLECULE_PTR *molecule1, *molecule2;
    SLOT *psubterm, *csubterm;
    SLOT   *workstack[WORKSTACKSIZE];
    SLOT   **stack;
    SLOT   *INITPTUPLE,*INITCTUPLE, *temptuple;
    SLOT   *loopPtuple, *loopCtuple;
    extern SLOT Y[];
/*    extern LONG PTuplemask;  */

    stack = workstack + 1;
    INITPTUPLE = ptuple; /* constant for the invocation */
    INITCTUPLE = ctuple; /* constant for the invocation */
    while (stack > workstack && (ptuple != ctuple || pterms != cterms))   
    { 
	if (stack > (workstack + WORKSTACKSIZE))
	{
	    OsPrint("Unify: nesting level in term too deep - aborting execution\n");
	    OsKillSys();
	}
	if (!SAME_FUNCTOR_ARITY(pterms, cterms))
    	    return(FALSE);
	arity = ARITY(pterms);
	for(i=1, loopPtuple = ptuple, loopCtuple = ctuple; 
	    i <= arity;
	    i++, ptuple = loopPtuple, ctuple = loopCtuple)
	{ 
	    psubterm = &pterms[i];
	    Deref_Term(psubterm, ptuple);
	    csubterm = &cterms[i];
	    Deref_Term(csubterm, ctuple);
	    
	    if (TAG_IS_FUNCTOR(psubterm) &&  TAG_IS_FUNCTOR(csubterm))
	    {
	    	if (!SAME_FUNCTOR_ARITY(psubterm, csubterm))
	    		return(FALSE);
		else if (!ARITY_IS_ZERO(psubterm))
		{   
		    *stack++ = psubterm;
		    *stack++ = ptuple;
		    *stack++ = csubterm;
		    *stack++ = ctuple;
		    *stack++ = (SLOT *)thrumolecule;
		}
	    }
	    else  /* both are not functors */
	    {
		pdone = FALSE;
		while (!pdone)
		switch (SLOT_TAG(psubterm))
		{ 
		case MOLECULE:
			molecule1 = MOLECULE_ADDRESS(psubterm);
			cdone= FALSE;
			while (!cdone)
			switch (SLOT_TAG(csubterm))
			{ 
			case MOLECULE:
			    molecule2 = MOLECULE_ADDRESS(csubterm);
			    if (TERMS(molecule1) != TERMS(molecule2))
			    { 
				csubterm = TERMS(molecule2);
				ctuple = TUPLE(molecule2);
			    }
			    else cdone = TRUE;
			    break;
			case FUNCTOR:
			case CLOSED_TERM:
			    *stack++ = TERMS(molecule1);
			    *stack++ = TUPLE(molecule1);
			    *stack++ = csubterm;
			    *stack++ = ctuple;
			    *stack++ = (SLOT *)TRUE;
			    cdone= TRUE;
			    break;
			case TUPLE_INDEX_1:
			    COPY_MOLECULE(&(ctuple[INDEX(csubterm)]),psubterm, molecule1);
			    cdone= TRUE;
			    break;
			case TUPLE_INDEX_2:
			    temptuple = (ctuple == INITCTUPLE) ? INITPTUPLE : INITCTUPLE;
			    csubterm = &(temptuple[INDEX(csubterm)]);
			    ctuple = temptuple;
			    break;
			case TERM_SPC_INDEX_2:
			    csubterm = &(term_space[INDEX(csubterm)]);
			    ctuple = (ctuple == INITCTUPLE) ? INITPTUPLE : INITCTUPLE;
			    break;
			default:
			    return(FALSE);
			}
			pdone = TRUE;
			break;

		case FUNCTOR:
		case CLOSED_TERM:
			cdone= FALSE;
			while (!cdone)
			switch (SLOT_TAG(csubterm))
			{ 
			case MOLECULE:
			    molecule1 = MOLECULE_ADDRESS(csubterm);
			    *stack++ = psubterm;
			    *stack++ = ptuple;
			    *stack++ = TERMS(molecule1);
			    *stack++ = TUPLE(molecule1);
			    *stack++ = (SLOT *)TRUE;
			    cdone= TRUE;
			    break;

			case FUNCTOR:
			case CLOSED_TERM:
			    if (!SAME_FUNCTOR_ARITY(psubterm, csubterm))
			    	return(FALSE);
			    if (!ARITY_IS_ZERO(psubterm))
			    {
				*stack++ = psubterm;
				*stack++ = ptuple;
				*stack++ = csubterm;
				*stack++ = ctuple;
				*stack++ = (SLOT *)thrumolecule;
			    }
			    cdone= TRUE;
			    break;
			case TUPLE_INDEX_1:
			    if (ARITY_IS_ZERO(psubterm))
			    	COPY_ATOM(&(ctuple[INDEX(csubterm)]), psubterm);
			    else if ((ptuple == ctuple) || TAG_IS_CLOSED_TERM(psubterm))
			    {
			    	INSERT_ADDRESS(&(ctuple[INDEX(csubterm)]),psubterm);
			    }
			    else if (thrumolecule)
			    { 
				Malloc_Molecule(molecule1);
	 			INSERT_MOLEC_TERMS(molecule1, psubterm);
				INSERT_MOLEC_TUPLE(molecule1, ptuple);
				INSERT_MOLECULE(&(ctuple[INDEX(csubterm)]), molecule1);
			    }
			    else
				INSERT_TERM_INDEX(&(ctuple[INDEX(csubterm)]),
					       (psubterm - term_space), TERM_SPC_INDEX_2);
			    cdone= TRUE;
			    break;
			case TUPLE_INDEX_2:
			    temptuple = (ctuple == INITCTUPLE) ? INITPTUPLE : INITCTUPLE;
			    csubterm = &(temptuple[INDEX(csubterm)]);
			    ctuple = temptuple;
			    break;
			case TERM_SPC_INDEX_2:
			    csubterm = &(term_space[INDEX(csubterm)]);
			    ctuple = (ctuple == INITCTUPLE) ? INITPTUPLE : INITCTUPLE;
			    break;
			default:
			    return(FALSE);
			}
			pdone = TRUE;
			break;

		case TUPLE_INDEX_2:
			temptuple = (ptuple == INITPTUPLE) ? INITCTUPLE : INITPTUPLE;
			psubterm = &(temptuple[INDEX(psubterm)]);
			ptuple = temptuple;
			if (!TAG_IS_UNBOUND(psubterm))
			   break;

		case TUPLE_INDEX_1:
			/* ptuple[index] must be unbound */
/*			PTuplemask |= (1 << INDEX(psubterm));  */
			if (TAG_IS_TUPLE_INDEX_1(psubterm))
			   psubterm = &(ptuple[INDEX(psubterm)]);
			switch (SLOT_TAG(csubterm))
			{ 
			case MOLECULE:
			    molecule1 = MOLECULE_ADDRESS(csubterm);
			    COPY_MOLECULE(psubterm, csubterm, molecule1);
			    break;
			case FUNCTOR:
			    if (ptuple == ctuple)
			    	 index = TERM_SPC_INDEX_1;
			    else index = TERM_SPC_INDEX_2;
			    INSERT_TERM_INDEX(psubterm,(csubterm - term_space), index);
			    break;
			case CLOSED_TERM:
			    if (ARITY_IS_ZERO(csubterm))
			    	 COPY_ATOM(psubterm, csubterm);
			    else INSERT_ADDRESS(psubterm, csubterm);
			    break;
			case TUPLE_INDEX_1:
			    /* check whether they point to the same variable */
			    if (&ctuple[INDEX(csubterm)] != psubterm)
			    {
				if (ptuple == ctuple)
				     index = TUPLE_INDEX_1;
				else index = TUPLE_INDEX_2;
				COPY_INDEX(psubterm,csubterm, index);
			    }
			    break;
			case TUPLE_INDEX_2:
			    if (ptuple == ctuple)
			    	 index = TUPLE_INDEX_2;
			    else index = TUPLE_INDEX_1;
			    COPY_INDEX(psubterm, csubterm, index);
			    break;
			case TERM_SPC_INDEX_2:
			    if (ptuple == ctuple)
			    	 index = TERM_SPC_INDEX_2;
			    else index = TERM_SPC_INDEX_1;
			    COPY_INDEX(psubterm, csubterm, index);
			    break;
			case INTEGER:
			    COPY_INTEGER(psubterm,csubterm);
			    break;
			case REAL:
			    COPY_REAL(psubterm, csubterm);
			    break;
			default:
			    return(FALSE);
			}
			pdone = TRUE;
			break;

		case TERM_SPC_INDEX_2:
			psubterm =  &(term_space[INDEX(psubterm)]);
			ptuple = (ptuple == INITPTUPLE) ? INITCTUPLE : INITPTUPLE;
			break;

		case INTEGER:
			cdone= FALSE;
			while (!cdone)
			switch (SLOT_TAG(csubterm))
			{ 
			case TUPLE_INDEX_1:
			    COPY_INTEGER(&(ctuple[INDEX(csubterm)]), psubterm);
			    cdone= TRUE;
			    break;
			case TUPLE_INDEX_2:
			    temptuple = (ctuple == INITCTUPLE) ? INITPTUPLE : INITCTUPLE;
			    csubterm = &(temptuple[INDEX(csubterm)]);
			    ctuple = temptuple;
			    break;
			case INTEGER:
			    if (INTVALUE(psubterm) != INTVALUE(csubterm))
			    return(FALSE);
			    cdone= TRUE;
			    break;
			default:
			    return(FALSE);
			}
			pdone = TRUE;
			break;
			
		case REAL:
			cdone= FALSE;
			while(!cdone)
			switch (SLOT_TAG(csubterm))
			{ 
			case TUPLE_INDEX_1:
			    COPY_REAL(&(ctuple[INDEX(csubterm)]), psubterm);
			    cdone= TRUE;
			    break;
			case TUPLE_INDEX_2:
			    temptuple = (ctuple == INITCTUPLE) ? INITPTUPLE : INITCTUPLE;
			    csubterm = &(temptuple[INDEX(csubterm)]);
			    ctuple = temptuple;
			    break;
			case REAL:
			    if (REALVALUE(psubterm) != REALVALUE(csubterm))
			    	return(FALSE);
			    cdone = TRUE;
			    break;
			default:
			    return(FALSE);
			}
			pdone = TRUE;
			break;

		default:
			return(FALSE);
		}  /* while switch */
	    } /* else */
	}  /* for */

	/* next term */
	thrumolecule = (BOOLEAN) *--stack;
	ctuple = *--stack;
	cterms = *--stack;
	ptuple = *--stack;
	pterms = *--stack;
    }   /* while */
    return(TRUE);
}





BOOLEAN NoVarsIn(term, tuple)
SLOT  *term;
SLOT  *tuple;

{
    register SHORT i;
    SLOT     *subterm;
    SLOT     *workstack[WORKSTACKSIZE];
    SHORT    topofstack, arity;

    if (ARITY_IS_ZERO(term) || TAG_IS_CLOSED_TERM(term) || TAG_IS_MOLECULE(term))
    	return(TRUE);

    topofstack = 1;
    while (topofstack > 0)
    {
	arity = ARITY(term);
	for (i = 1; i <= arity; i++)
	{
	    subterm = &term[i];
	    Deref_Term(subterm, tuple);
	    switch (SLOT_TAG(subterm))
	    {
	    case FUNCTOR:
			if (!ARITY_IS_ZERO(subterm))
			    workstack[topofstack++] = subterm;
			if (topofstack >= WORKSTACKSIZE)
			{
			    OsPrint("NoVarsIn: nesting level in term too deep - aborting execution\n");
			    OsKillSys();
			}
			break;
	    case MOLECULE:
	    case CLOSED_TERM:
			break;
	    case TUPLE_INDEX_1:  /* the variable is unbound */
	    case TUPLE_INDEX_2:
	    case TERM_SPC_INDEX_2:
			return(FALSE);
			break;
	    }
	}
	term = workstack[--topofstack];
    }
    return(TRUE);
}




/* TermSize returns the size of the term as # of slots */

SHORT TermSize(term, tuple)
SLOT *term;
SLOT *tuple;
{ 
    register SHORT i;
    SHORT size;
    SLOT  *subterm;
    SHORT arity = ARITY(term);
    MOLECULE_PTR *molecule;

    if (TAG_IS_FUNCTOR(term))
    {
	size = 1 + arity;
	for (i = 1; i <= arity; i++)
	{
	    subterm = &term[i];
	    Deref_Term(subterm, tuple);
	    if (TAG_IS_FUNCTOR(subterm) && (!TAG_IS_CLOSED_TERM(subterm)) 
		&& !ARITY_IS_ZERO(subterm))
	    	size +=  TermSize(subterm, tuple);
	    else if (TAG_IS_SEQ_MOLECULE(subterm))
	    {
		molecule = SEQ_MOLECULE_ADDRESS(subterm);
	        size += TermSize(TERMS(molecule), TUPLE(molecule));
	    }
	}
	return(size);
    }
    else return(0);
}




/* copies from term1 to term2 and returns next free SLOT in term2*/

SLOT *CopyOneSweep(term1, term2) 
SLOT *term1;
SLOT *term2;

{
    register SHORT i;
    SLOT  *copyslot;
    SHORT arity = ARITY(term1);

    copyslot = term2;
    INSERT_FUNCTOR(copyslot, GET_FUNCTOR(term1), arity);
    copyslot++;
    while (TAG_IS_FUNCTOR(term1) && arity > 0)
    { 
	for (i = 1; i <= arity; i++, copyslot++)
		COPY_ATOM(copyslot, &(term1[i]));
    	term1 += arity;
	arity = ARITY(term1);
    }
    return(copyslot);
}




void CopyTerm(oldterm, oldtuple, newterm, newtupsize)
SLOT *oldterm;
SLOT *oldtuple;
SLOT **newterm;
SHORT *newtupsize;

{
    SLOT *nextslot;
    SLOT *currentslot;
    MOLECULE_PTR *molecule;
    SLOT *CopyOneSweep();
    register SHORT i;
    SHORT arity = ARITY(oldterm);

    nextslot = CopyOneSweep(oldterm, *newterm); 
/*  SET_REF_COUNT_ONE(*newterm);  */
    (*newterm)++;
    while (TAG_IS_FUNCTOR(oldterm) && arity > 0)
    {
	for ( i = 1; i <= arity ; i++,(*newterm)++)
	{ 
	    currentslot = &oldterm[i];
	    Deref_Term(currentslot, oldtuple);
	    switch (SLOT_TAG(currentslot))
	    { 
	    case MOLECULE:
			COPY_SLOT((*newterm), currentslot);
			break;
	    case SEQ_MOLECULE:
			molecule = SEQ_MOLECULE_ADDRESS(currentslot);
			INSERT_ADDRESS((*newterm), nextslot);
			CopyTerm(TERMS(molecule), TUPLE(molecule), &nextslot,
				 newtupsize);
			break;
	    case CLOSED_TERM:
			if (ARITY_IS_ZERO(currentslot))
			     COPY_ATOM((*newterm),currentslot);
			else INSERT_ADDRESS((*newterm), currentslot);
			break;
	    case FUNCTOR:
			if (ARITY_IS_ZERO(currentslot))
			    COPY_ATOM((*newterm),currentslot);
			else if (currentslot != (oldterm + i)) 
			{ 
			    INSERT_ADDRESS((*newterm), nextslot);
			    CopyTerm(currentslot,oldtuple, &nextslot, newtupsize);
			}
			break;
	    case UNBOUND_VAR:
			INSERT_INDEX((*newterm), *newtupsize, TUPLE_INDEX_1);
			(*newtupsize)++;
			break;

	    case TUPLE_INDEX_1:
			INSERT_INDEX((*newterm), *newtupsize, TUPLE_INDEX_1);
			INSERT_INDEX(&oldtuple[INDEX(currentslot)], *newtupsize, TUPLE_INDEX_2);
			(*newtupsize)++;
			break;
	    case TUPLE_INDEX_2:
			COPY_INDEX((*newterm), currentslot, TUPLE_INDEX_1);
			break;

	    case TERM_SPC_INDEX_2:
			COPY_INDEX((*newterm), currentslot, TERM_SPC_INDEX_1);
			break;

	    case INTEGER:
			COPY_INTEGER((*newterm), currentslot);
			break;

	    case REAL:
			COPY_REAL((*newterm), currentslot);
			break;

	    default:
			break;
	    }
	} 	/* for */
	oldterm += arity;
	arity = ARITY(oldterm);
    }  /* while */
    *newterm = nextslot;
}
		    




