
#include "host.h"
#include "cksys.h"

#include "qs_stack.h"
#include "qs_stack_macros.c"

#define TRACEQS(p)
#define MaxChares 20000 
#define MaxResps  20000 

SPINLOCK chareLock;
SPINLOCK respLock[MaxPe];

int	PrintQueStat = FALSE;
extern  shared	int numPe;

int	ChareStackLength = 0;
int	MaxChareStackLength = 0;

int	RespStackLength[MaxPe];
int	MaxStackLength[MaxPe];

int 	ChareHeapTop;
SYSMSG	*ChareHeap[MaxChares];

int 	RespHeapTop[MaxPe];
SYSMSG	*RespHeap[MaxPe][MaxResps];


QSInit()
{
	int i, j, Penum;

	OsSpinInit(chareLock);
	ChareHeapTop = -1;

	for (Penum=0; Penum < MaxPe; Penum++)
	{
 		OsSpinInit(respLock[Penum]);
		RespHeapTop[Penum] = -1;
 		RespStackLength[Penum] = 0;
 		MaxStackLength[Penum] = 0;
	}

	for (i=0; i < MaxChares; i++)
		ChareHeap[i] = NULLPTR;

	for(j=0; j < MaxPe; j++)
	   for (i=0; i < MaxResps; i++)
		RespHeap[j][i] = NULLPTR;
}


QSEmptyResponses(Penum)
int Penum;
{
	return( RespHeapTop[Penum] < 0 );
}

QSEmptyChares()
{
	return( ChareHeapTop < 0 );
}


QSEnQueueChare(EP,Msg,MsgSize,AR)
{
	OsPrintf("Incorrect CreateChare() call, use CreateChareGen() call\n");
	OsKillSys();
	exit(1);
}


QSEnQueueResponse(Penum,EP,Msg,MsgSize,AR)
{
	OsPrintf("Incorrect SendMsg() call, use SendMsgGen() call\n");
	OsKillSys();
	exit(1);
}


QSEnQueueChareGen(EP,Msg,MsgSize,AR,Prio,NeedToPack)
{
	SYSMSG	*mPtr;
/*
TRACEQS(OsPrintf("QSEnQueueChareGen: CHARE Priority = %o\n", Prio));
*/
	CREATE_SYS_MSG(mPtr, EP, Msg, AR, 0, SYSMSGTYPE_CHAR);

	QsLockChares();
	QmEnQueueChareMsg(mPtr);
	QsUnlockChares();
}


QSEnQueueResponseGen(Penum,EP,Msg,MsgSize,AR,Prio,NeedToPack)
{
	SYSMSG	*mPtr;
/*
TRACEQS(OsPrintf("QSEnQueueResponseGen: RESPMSG Priority = %o\n", Prio));
*/
	CREATE_SYS_MSG(mPtr, EP, Msg, AR, 0, SYSMSGTYPE_RESP);

	QsLockResponses(Penum);
	QmEnQueueRespMsg(mPtr, Penum);
	QsUnlockResponses(Penum);
}



PickNextMsg(MsgType, CurrentAR,  CurrentMsg,  CurrentEP)
 int *CurrentAR,  *CurrentMsg,  *CurrentEP;
 JOBTYPE *MsgType;
     /* First check if there is any response for local chares
	(note: this assumes anchoring, and so avoid the need to lock chares)
	If empty, check the global pool of CreateChare messages */
{ QsLockResponses(MyPenum);
  if (QSEmptyResponses(MyPenum))
    {QsUnlockResponses(MyPenum);
     QsLockChares();
     if (QSEmptyChares()) {QsUnlockChares(); return(NULL); }
       else { QSDeQueueChare(MsgType,CurrentAR,CurrentMsg,CurrentEP); 
	      QsUnlockChares(); }}
  else
    {QSDeQueueResponse(MyPenum,MsgType,CurrentAR,CurrentMsg,CurrentEP);
     QsUnlockResponses(MyPenum);}
return(1);
}



QSDeQueueChare(MsgType,CurrentAR,CurrentMsg,CurrentEP)
int *CurrentAR, *CurrentMsg, *CurrentEP;
JOBTYPE *MsgType;
{
	SYSMSG	*mPtr, *QmDeQueueChareMsg();

	mPtr = QmDeQueueChareMsg();

	*MsgType    = JOBTYPE_CHARE;
 	*CurrentAR  = mPtr->AR;
 	*CurrentMsg = mPtr->Msg;
 	*CurrentEP  = mPtr->EP;

	Free_SysMsg(mPtr, sizeof(SYSMSG));
}



QSDeQueueResponse(Penum, MsgType, CurrentAR, CurrentMsg, CurrentEP)
int *CurrentAR, *CurrentMsg, *CurrentEP;
int Penum;
JOBTYPE *MsgType;
{
	SYSMSG	*mPtr, *QmDeQueueRespMsg();

	mPtr = QmDeQueueRespMsg(Penum);

	*MsgType    = JOBTYPE_RESP;
 	*CurrentAR  = mPtr->AR;
 	*CurrentMsg = mPtr->Msg;
 	*CurrentEP  = mPtr->EP;

	Free_SysMsg(mPtr, sizeof(SYSMSG));
}



QmEnQueueChareMsg(mPtr)
SYSMSG	*mPtr;
{
	int 	parent, child;

	ChareHeapTop++;

	if ( ChareHeapTop > MaxChares )
	{
		OsPrintf("ChareHeap Overflow: Heap Size set to %d\n",MaxChares);
		OsKillSys();
		exit(1);
	}

	if ( PrintQueStat == TRUE )
	{
		ChareStackLength++;
		if ( ChareStackLength > MaxChareStackLength)
			MaxChareStackLength = ChareStackLength;
	}

	child = ChareHeapTop;
	if (child > 0)
		parent = (ChareHeapTop-1) >> 1; /* array starts at zero */
	else
		parent = 0;

	/* while child >0 & parent priority > mPtr->priority */
	while ( (child > 0) && 
		(ChareHeap[parent]->sysMsgPVector > mPtr->sysMsgPVector) )
	{

		ChareHeap[child] = ChareHeap[parent];
		ChareHeap[child]->sysMsgPVector = ChareHeap[parent]->sysMsgPVector;

		child = parent;
		parent = (parent-1) >> 1; /* array starts at zero */
	}
	ChareHeap[child] = mPtr;
}


SYSMSG 	*QmDeQueueChareMsg()
{
	SYSMSG		*mPtr = NULLPTR;

     if (ChareHeap[0] != NULLPTR)
     {
	mPtr = ChareHeap[0];
	ChareHeap[0] = NULLPTR;
	mPtr->sysMsgNextPtr = NULLPTR;

	if ( PrintQueStat == TRUE ) ChareStackLength--;

	/* Restore the ChareHeap */
	QmRestoreChareHeap();
     }
     return(mPtr);
}


/* reorganize the heap */
QmRestoreChareHeap()
{

	SYSMSG		*temp_stack_ptr;
	int		temp_priority;
	int 		parent=0, child1=1, child2=2, min;
	int		NotDone=1, last_item;

	last_item = ChareHeapTop;
   	ChareHeapTop--;

	switch (last_item)
	{
	case 0 :
	   	ChareHeap[0] = NULLPTR;
		break;

	case 1 :
		ChareHeap[0] = ChareHeap[1];
	   	ChareHeap[1] = NULLPTR;
		break;

	default :
	   temp_stack_ptr = ChareHeap[last_item];
	   temp_priority = ChareHeap[last_item]->sysMsgPVector;
	   ChareHeap[last_item] = NULLPTR;

	   while ( child1 <= ChareHeapTop && NotDone==1 )
	   {
		min = child1;
		if ((child2 <= ChareHeapTop) && 
		   (ChareHeap[child1]->sysMsgPVector > ChareHeap[child2]->sysMsgPVector))
		   min = child2;

		if (temp_priority > ChareHeap[min]->sysMsgPVector) 
		{
		   ChareHeap[parent] = ChareHeap[min];

		   parent = min;
	   	   child2 = (parent +1) << 1;
	   	   child1 = child2 - 1;
		}
		else  
		   NotDone = 0;
	   } /* while */
	   ChareHeap[parent] = temp_stack_ptr;

	} /* switch */
}


QmEnQueueRespMsg(mPtr,Penum)
SYSMSG	*mPtr;
int	Penum;
{
	int 	parent, child;
	int	j, TotStackLength = 0;

	RespHeapTop[Penum]++;

	if ( RespHeapTop[Penum] > MaxResps )
	{
		OsPrintf("ResponseHeap Overflow for PE %d: Heap Size set to %d\n", Penum, MaxResps);
		OsKillSys();
		exit(1);
	}

	if ( PrintQueStat == TRUE )
	{
		RespStackLength[Penum]++;
		for (j=0; j<numPe; j++) 
 		TotStackLength += RespStackLength[j];
	
 		TotStackLength += ChareStackLength;

		if( TotStackLength > MaxStackLength[Penum] )
			MaxStackLength[Penum] = TotStackLength;
	}

	child = RespHeapTop[Penum];
	if (child > 0)
		parent = (RespHeapTop[Penum]-1) > 1; /* array starts at zero */
	else
		parent = 0;

	/* while child >0 & parent priority > mPtr->priority */
	while ( (child > 0) && 
		(RespHeap[Penum][parent]->sysMsgPVector > mPtr->sysMsgPVector) )
	{
		RespHeap[Penum][child] = RespHeap[Penum][parent];

		child = parent;
		parent = (parent-1) > 1; /* array starts at zero */
	}
	RespHeap[Penum][child] = mPtr;

}


SYSMSG 	*QmDeQueueRespMsg(Penum)
int	Penum;
{
	SYSMSG		*mPtr = NULLPTR;

     if (RespHeap[Penum][0] != NULLPTR)
     {
	mPtr = RespHeap[Penum][0];
	RespHeap[Penum][0] = NULLPTR;
	mPtr->sysMsgNextPtr = NULLPTR;

	if ( PrintQueStat == TRUE ) RespStackLength[Penum]--;

	/* Restore the Heap */
	QmRestoreRespHeap(Penum);
     }
     return(mPtr);
}


/* Restore Response Heap */
QmRestoreRespHeap(Penum)
int	Penum;
{

	SYSMSG		*temp_stack_ptr;
	int		temp_priority;
	int 		parent=0, child1=1, child2=2, min;
	int		NotDone=1, last_item;

	last_item = RespHeapTop[Penum];
   	RespHeapTop[Penum]--;

	switch (last_item)
	{
	case 0 :
	   	RespHeap[Penum][0] = NULLPTR;
		break;

	case 1 :
		RespHeap[Penum][0] = RespHeap[Penum][1];
	   	RespHeap[Penum][1] = NULLPTR;
		break;

	default :
	   temp_stack_ptr = RespHeap[Penum][last_item];
	   temp_priority = RespHeap[Penum][last_item]->sysMsgPVector;
	   RespHeap[Penum][last_item] = NULLPTR;

	   while ( child1 <= RespHeapTop[Penum] && NotDone==1 )
	   {
		min = child1;
		if ((child2 <= RespHeapTop[Penum]) && 
		   (RespHeap[Penum][child1]->sysMsgPVector > RespHeap[Penum][child2]->sysMsgPVector))
		   min = child2;

		if (temp_priority > RespHeap[Penum][min]->sysMsgPVector) 
		{
		   RespHeap[Penum][parent] = RespHeap[Penum][min];

		   parent = min;
	   	   child2 = (parent +1) << 1;
	   	   child1 = child2 - 1;
		}
		else  
		   NotDone = 0;
	   } /* while */
	   RespHeap[Penum][parent] = temp_stack_ptr;

	} /* switch */
}


QsLockChares()
{
    OsSpinLock( chareLock );
}


QsUnlockChares()
{
    OsSpinUnlock( chareLock );
}


QsLockResponses(Penum)
int Penum;
{
    OsSpinLock( respLock[Penum] );
}


QsUnlockResponses(Penum)
int Penum;
{
    OsSpinUnlock( respLock[Penum] );
}


QueueStatus()
{
	int i, max_stack_length = 0;

	if ( PrintQueStat == TRUE )
	{
	for ( i=0; i<numPe; i++)
		if ( MaxStackLength[i] > max_stack_length )
			max_stack_length = MaxStackLength[i];

	OsPrintf("Queue Status:\n");
	OsPrintf("MaxChareStackLength %d", MaxChareStackLength);
	OsPrintf("MaxStackLength %d\n", max_stack_length);
	}

}
