/*
 * PCN System
 * Author:      Steve Tuecke
 *              Argonne National Laboratory
 *
 * Please see the DISCLAIMER file in the top level directory of the
 * distribution regarding the provisions under which this software
 * is distributed.
 *
 * pcn_stdio.h
 *
 * Header file for the PCN stdio module.
 */

#ifndef _PCN_INCLUDE_PCN_STDIO_H
#define _PCN_INCLUDE_PCN_STDIO_H

#ifdef PCN

#define FILE int
#define NULL 0
#define EOF -1

/* Values for the 'whence' argument of fseek() */
#define SEEK_SET 0	/* relative to the beginning of the file */
#define SEEK_CUR 1	/* relative to current position */
#define SEEK_END 2	/* relative to the end of the file */

/* Values for the 'mode' argument of access() */
#define R_OK    4	/* test for read permission */
#define W_OK    2	/* test for write permission */
#define X_OK    1	/* test for execute (search) permission */
#define F_OK    0	/* test for presence of file */

#else  /* PCN */

#include <stdio.h>

#endif /* PCN */

#endif /* _PCN_INCLUDE_PCN_STDIO_H */
