/*
 * PCN System -- PCN Object file access routines
 * Author:      Steve Tuecke
 *              Argonne National Laboratory
 *
 * Please see the DISCLAIMER file in the top level directory of the
 * distribution regarding the provisions under which this software
 * is distributed.
 *
 * pcno.c
 *
 * This file contains the C procedures needed by the pcno routines.
 */

#include "pcn_types.h"
#include "pcn_structs.h"
#include "pcno.h"


/*
 * _p_pcno_etoi()
 *
 * Convert external format integer (big endian) to an internal format
 * integer (a PCN integer).  The external format integer starts
 * at the 'byte_n' byte in the 'ebuf' character array.
 *
 * Set 'i' to be the internal format integer.
 */
_p_pcno_etoi(ebuf, byte_n, i)
char_t *ebuf;
int_t *byte_n;
int_t *i;
{
    char_t *P = ebuf + *byte_n;
    *i = ((int_t) (  (((u_int_t) *((unsigned char *) (P))) << 24)
		   | (((u_int_t) *(((unsigned char *) (P)) + 1)) << 16)
		   | (((u_int_t) *(((unsigned char *) (P)) + 2)) << 8)
		   | (((u_int_t) *(((unsigned char *) (P)) + 3))) ));
}


/*
 * _p_pcno_itoe()
 *
 * Convert internal format integer (a PCN integer) to an external
 * format integer (big endian).  The external format integer
 * is stored in a character array.
 *
 * Set 'e' to be the external format integer (character array).
 */
_p_pcno_itoe(i, e)
u_int_t *i;
unsigned char e[PCNO_WORD_SIZE];
{
    e[0] = (*i & 0xFF000000) >> 24;
    e[1] = (*i & 0x00FF0000) >> 16;
    e[2] = (*i & 0x0000FF00) >> 8;
    e[3] = (*i & 0x000000FF);
}

