/*
 * PCN System Linker -- pcnlink
 * Author:      Steve Tuecke
 *              Argonne National Laboratory
 *
 * Please see the DISCLAIMER file in the top level directory of the
 * distribution regarding the provisions under which this software
 * is distributed.
 *
 * link_dout.c		- Support routines for link_dout.pcn
 *
 * Foreign procedures used for information generation
 * into the custom info file.
 */

#include "link_internal.h"


/*
 * _p_link_dout_for_table()
 */
void _p_link_dout_for_table(buf, buf_len, for_table_size)
char_t *buf;
int_t *buf_len;
int_t *for_table_size;
{
    sprintf((char *) buf,
	    "int _p_foreign_table_size = %ld;\n",
	    (long) *for_table_size);
#ifdef DEBUG_BUF_OVERFLOW
    if (strlen((char *) buf) >= *buf_len)
    {
	fprintf(stderr,
		"Fatal Error: _p_link_dout_for_table(): Buffer overflow\n");
	exit_from_c(1);
    }
#endif    
} /* _p_link_dout_for_table() */


/*
 * _p_link_dout_exported_table()
 */
void _p_link_dout_exported_table(buf, buf_len, table_size)
char_t *buf;
int_t *buf_len;
int_t *table_size;
{
    sprintf((char *) buf,
	    "int_t _p_exported_table_size = %ld;\n",
	    (long) *table_size);
#ifdef DEBUG_BUF_OVERFLOW
    if (strlen((char *) buf) >= *buf_len)
    {
	fprintf(stderr,
		"Fatal Error: _p_link_dout_exported_table(): Buffer overflow\n");
	exit_from_c(1);
    }
#endif    
} /* _p_link_dout_exported_table() */
