/*
 * PCN System Linker -- pcnlink
 * Author:      Steve Tuecke
 *              Argonne National Laboratory
 *
 * Please see the DISCLAIMER file in the top level directory of the
 * distribution regarding the provisions under which this software
 * is distributed.
 *
 * link.c		- Support routines for link.pcn
 *
 * Foreign procedures used by the PCN linker code.
 */

#include "link_internal.h"


/*
 * _p_link_get_table_index()
 *
 * This procedure uses the 'module_name', 'proc_name' (strings), and
 * 'table_size' (integer) to return the appropriate index
 * a procedure lookup hash table.
 */
void _p_link_get_table_index(module_name, proc_name, table_size,
			     table_index)
char_t *module_name;
char_t *proc_name;
int_t *table_size;
int_t *table_index;
{
    u_int_t y = 0;
    int_t i;
    while ((i = (int_t) (*module_name++)) != 0)
    {
	y <<= 1;
	y += i;
    }
    while ((i = (int_t) (*proc_name++)) != 0)
    {
	y <<= 1;
	y += i;
    }
    *table_index = (int_t) (y % *table_size);
} /* _p_link_get_table_index() */



/******** This should move into the emulator *************/
/*
 * _p_hash_index_for_procedure_name()
 *
 * This procedure uses the 'module_name', 'proc_name' (strings), and
 * 'table_size' (pointer to integer) to return the appropriate
 * hash table index for this procedure name in 'hash_index'.
 */
void _p_hash_index_for_procedure_name(module_name, proc_name, table_size,
				      hash_index)
char_t *module_name;
char_t *proc_name;
int_t *table_size;
int_t *hash_index;
{
    u_int_t y = 0;
    int_t i;
    while ((i = (int_t) (*module_name++)) != 0)
    {
	y <<= 1;
	y += i;
    }
    while ((i = (int_t) (*proc_name++)) != 0)
    {
	y <<= 1;
	y += i;
    }
    *hash_index = (int_t) (y % *table_size);
} /* _p_hash_index_for_procedure_name() */

