
#define D_INTEGER 1
#define D_DOUBLE 2
#define D_STRING 3
#define D_TUPLE 4
#define D_LIST 5
#define D_NIL 6
#define D_TAG 7
#define D_QUOTED_BLOCK 8

#ifndef PCN

struct _datum;

typedef struct _tuple
{
    int len;
    struct _datum **args;
}  tuple;


#define T_NARGS(t) ((t)->len)
#define T_ARGS(t) ((t)->args)
#define T_ARG(t,i) ((t)->args[i])

typedef struct _list
{
    struct _datum *head;
    struct _datum **tail;
} list;

#define L_HEAD(l) ((l)->head)
#define L_TAIL(l) ((l)->tail)

typedef struct _datum
{
    union
    {
	int ival;
	double dval;
	char *sval;
	tuple *tval;
	list *lval;
    } data;
    int type;
} datum, *datum_ptr;

#define D_TYPE(d) ((d)->type)
#define D_IVAL(d) ((d)->data.ival)
#define D_DVAL(d) ((d)->data.dval)
#define D_SVAL(d) ((d)->data.sval)
#define D_TVAL(d) ((d)->data.tval)
#define D_LVAL(d) ((d)->data.lval)
#define D_NARGS(d) ((d)->data.tval->len)
#define D_ARGS(d) ((d)->data.tval->args)
#define D_ARG(d,i) ((d)->data.tval->args[i])

#define D_CAR(d) D_ARG(d, 0)
#define D_CDR(d) D_ARG(d, 1)

#define D_LHEAD(d) (L_HEAD(D_LVAL(d)))
#define D_LTAIL(d) (L_TAIL(D_LVAL(d)))

static char *_p_co_type_names[] = {
    "",
    "integer",
    "double",
    "string",
    "tuple",
    "list",
    "nil",
    "tag",
};
    

#define D_IS_INTEGER(d) (D_TYPE(d) == D_INTEGER)
#define D_IS_DOUBLE(d) (D_TYPE(d) == D_DOULBE)
#define D_IS_STRING(d) (D_TYPE(d) == D_STRING)
#define D_IS_TUPLE(d) (D_TYPE(d) == D_TUPLE)
#define D_IS_LIST(d) (D_TYPE(d) == D_LIST)
#define D_IS_NIL(d) (D_TYPE(d) == D_NIL)
#define D_IS_TAG(d) (D_TYPE(d) == D_TAG)
#define D_IS_QUOTED_BLOCK(d) (D_TYPE(d) == D_QUOTED_BLOCK)

/*
#define UNLIST(t) (t == NULL ? NULL : (D_TYPE(t) == D_LIST ? D_LHEAD(t) : (t)))
*/
#define REAL_UNLIST(t) (t == NULL ? NULL : (D_TYPE(t) == D_LIST ? D_LHEAD(t) : (t)))
#define UNLIST(t) (t)

#define D_NEW_TUPLE_1(t, a1) t = _p_co_new_tuple(1); _p_co_set_arg(t, 0, a1);

#define D_NEW_TUPLE_2(t, a1, a2) t = _p_co_new_tuple(2); \
    _p_co_set_arg(t, 0, a1); \
    _p_co_set_arg(t, 1, a2);

#define D_NEW_TUPLE_3(t, a1, a2, a3) t = _p_co_new_tuple(3); \
    _p_co_set_arg(t, 0, a1); \
    _p_co_set_arg(t, 1, a2); \
    _p_co_set_arg(t, 2, a3);

#define D_NEW_TUPLE_4(t, a1, a2, a3, a4) t = _p_co_new_tuple(4); \
    _p_co_set_arg(t, 0, a1); \
    _p_co_set_arg(t, 1, a2); \
    _p_co_set_arg(t, 2, a3); \
    _p_co_set_arg(t, 3, a4);

#define D_NEW_TUPLE_5(t, a1, a2, a3, a4, a5) t = _p_co_new_tuple(5); \
    _p_co_set_arg(t, 0, a1); \
    _p_co_set_arg(t, 1, a2); \
    _p_co_set_arg(t, 2, a3); \
    _p_co_set_arg(t, 3, a4);\
    _p_co_set_arg(t, 4, a5);

extern datum *_p_co_new_tag();
extern datum *_p_co_new_integer();
extern datum *_p_co_new_double();
extern datum *_p_co_new_string();
extern datum *_p_co_new_string_len();
extern datum *_p_co_new_tuple();
extern datum *_p_co_new_quoted_block();

extern datum *_p_co_new_list_0();
extern datum *_p_co_new_list();
extern datum *_p_co_append_list();

extern datum *_p_co_nil();

extern datum *_p_co_cons();

extern datum *_p_co_set_arg();
extern datum *_p_co_get_arg();

extern void _p_co_free();

extern void _p_co_print();

extern datum *_p_co_new_tuple_1();
extern datum *_p_co_new_tuple_2();
extern datum *_p_co_new_tuple_3();
extern datum *_p_co_new_tuple_4();
extern datum *_p_co_new_tuple_5();

#endif /* PCN */
