#ifndef _PCN_INCLUDE_CO_PARSE_H
#define _PCN_INCLUDE_CO_PARSE_H

#ifdef PCN

#define PARSE_TREE int
#include "pcn_parse.h"
#include "parser_tags.h"

#else /* PCN */

#include "pcn_parse.h"
#include "parser_tags.h"
#include "symbol_redef.h"

#define YYSTYPE datum_ptr

/*
 * Some lex's (NeXT's in particular) define the maximum token length
 * to be ridiculously small (200 characters...). This can cause bizarre
 * crashes when compiling code with long string constants. We redefine
 * the maximum token length here to be something "large enough".
 *
 * We also check the length of yytext in some of the rules in lex.l in an
 * attempt to discover the error and die (somewhat) gracefully.
 */
#define LEX_INPUT_BUFFER_SIZE 8192

/*
 * The bison-generated gram.c doesn't compile well if these are included.
 */
#ifndef YYBISON

#include "gram.h"

extern YYSTYPE yylval;

#endif /* YYBISON */

#include <stdio.h>

#ifdef DEFINE_GLOBALS
#define GLOBAL
#else
#define GLOBAL extern
#endif

/*
 * Variables to keep track of the maximum index for the _l and _g
 * temporary variables.
 */

GLOBAL int _p_co_l_temp_max;
GLOBAL int _p_co_g_temp_max;

GLOBAL int _p_co_error_count;

GLOBAL int _p_co_lineno;

GLOBAL int _p_co_allow_assignment_in_guard;

#ifdef DEFINE_GLOBALS
char _p_co_filename[1024];
#else
extern char _p_co_filename[];
#endif

GLOBAL int _p_co_parse_done_flag;
GLOBAL int _p_co_parse_completely_done_flag;

GLOBAL int _p_co_push_token;

#ifdef DEFINE_GLOBALS
int _p_co_backward_compatibility_flag = 1;
#else
extern int _p_co_backward_compatibility_flag;
#endif

GLOBAL datum *_p_co_parse_tree;

extern FILE *_p_co_yyin;

#ifndef NULL
#define NULL (void *) 0
#endif

    
extern void _p_co_check_var_for_temp_max();
extern void _p_co_init_parsing();
extern void _p_co_parse_one_form();
extern void _p_co_get_parse_error_count();
extern void _p_co_free_parse_tree();
extern void _p_co_syntax_error();
extern void _p_co_warning();
extern void _p_co_get_global_temp_max();
extern void _p_co_print_parse_tree();
extern void _p_co_get_datum_type();
extern void _p_co_get_double_datum();
extern void _p_co_get_int_datum();
extern void _p_co_get_list_head_datum();
extern void _p_co_get_string();
extern void _p_co_get_string_len();
extern void _p_co_get_tag_datum();
extern void _p_co_get_tuple_len();
extern void _p_co_get_tuple_arg();
extern void _p_co_set_backward_compatibility();

#endif /* PCN */

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif


#endif /* _PCN_INCLUDE_CO_PARSE_H */
