/*
 * $Header: /ufs/comp/mei/PROJ_PCN/onprofile/IFModel/Xsw/RCS/Xsw.h,v 1.1 1992/04/17 21:10:07 mei Exp $
 */

/******************************************************************************
*									      *
*	Copyright (C) The Aerospace Corporation 1991			      *
*									      *
*	This software was developed by The Aerospace Corporation as a 	      *
*	research endeavor for the United States Air Force 		      *
*	Space Systems Division.  The current version of the Gauge	      *
*	computer program is available for  release to you for		      *
*	educational and research purposes only.  It is not 		      *
*	to be used for commercial purposes.				      *
*									      *
*	In addition, the following conditions shall apply.		      *
*									      *
*	1) The computer software and documentation were designed to	      *
*	satisfy internal Aerospace requirements only.			      *
*	The software is provided ``as is,'' and The Aerospace Corporation     *
*	makes no warranty, expressed or implied, as to it accuracy,	      *
*	functioning, or fitness for a particular purpose.		      *
*									      *
*	2) The Aerospace Corporation and its personnel are not		      *
*	responsible for providing technical support or general assistance     *
*	with respect to the software.					      *
*									      *
*	3) Neither The Aerospace Corporation nor its personnel shall be	      *
*	liable for claims, losses, or damages arising out of or connected     *
*	with the use of this software.					      *
*	Your sole and exclusive remedy shall be to request a replacement      *
*	copy of the program.						      *
*									      *
******************************************************************************/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

typedef struct {
  String string;
  XtCallbackRec * callback;
} SCPair;
#define XtRSCPair "SCPair"

typedef SCPair * SCPairList;
#define XtRSCPairList "SCPairList"

#define XtRPixelList   "PixelList"
typedef Pixel * PixelList;

typedef int PType;
#define XswCenter 1
#define XswRight 2
#define XswLeft 3
#define XswTop 4
#define XswBottom 5
#define XswMouse 9

#define XtRStringList   "StringList"
typedef String * StringList;
#define XtNNULL "NULL"
#define XtNEMPTY "EMPTY"

#define XtRStringSet "StringSet"
typedef StringList * StringSet;


#ifndef FILENAME_MAX
#define FILENAME_MAX 512
#endif
/* The following functions are included in Widgets.c */

/*      Function Name: XswGetLibName.
 *      Description: The normal interface to the XswLibDir facility.
 *                   It will search through a list of directories
 *                   beginning with the current directory and continuing
 *                   through all directory in the libDir resource until
 *                   in finds a file with the reusted name.  If such a
 *                   file is found then it will be returned; otherwise, 
 *                   a NULL string will be returned.
 *      Arguments:   name - the file to search for.
 *      Returns: a full path to the file if found; otherwise, a NULL string.
 */
extern String XswGetLibName(
#if NeedFunctionPrototypes
   String name 
#endif
);

/*      Function Name: XswStrCmp.
 *      Description: Compares two strings work ignoring case.
 *      Arguments: s1, s2 - the Strings to compare.
 *      Returns: True is the strings match, False otherwise.
 */
extern Boolean XswStrCmp(
#if NeedFunctionPrototypes
    String s1, String s2
#endif
);


/*      Function Name: XswMainLoop.
 *      Description: Replacement for XtMainLoop, provides better
 *                   error and warning handling.
 *      Arguments: none.
 *      Returns: none.
 */
extern void XswMainLoop();


/*      Function Name: XswAppMainLoop.
 *      Description: Replacement for XtAppMainLoop, provides better
 *                   error and warning handling.
 *      Arguments: app_context - the application context to use.
 *      Returns: none.
 */
extern void XswAppMainLoop(/*XtAppContext app_context*/);


/*      Function Name: XswDisplayWarnings.
 *      Description: Used in XswMainLoop to display warnings and errors.
 *      Arguments: app_context - the application context to use.
 *                 if this is NULL then use the default.
 *      Returns: none.
 */
extern void XswDisplayWarnings(/*XtAppContext app_context*/);


/*      Function Name: XswWarning.
 *      Description: A replacement for XtWarning, must be used in 
 *                   conjunction with XswMainLoop or XswDisplayWarnings.
 *      Arguments: message - the message to display.
 *      Returns: none.
 */
extern void XswWarning(/*String message*/);


/*      Function Name: XswError.
 *      Description: A replacement for XtError, must be used in 
 *                   conjunction with XswMainLoop or XswDisplayWarnings.
 *      Arguments: message - the message to display.
 *      Returns: none.
 */
extern void XswError(/* message */);


extern Widget XswPopupBox(/* w, name, text */);
extern Widget XswPopupBoxPlus(/* w, name, text, position, grab_type */);
extern void XswPositionPopup(/* w, position */);
extern void XswPositionWidget(/* w, origin_w, position */);

extern void XswGrapPointer(/*Widget  w*/);
extern Boolean XswIsVisible(/*Widget w*/);
extern Widget XswGetShell(/*Widget w*/);
extern Display * XswGetDisplay(/*XtAppContext app_context*/);

extern void XswFreeMemCallback(/* w, name, text */);
extern void XswFreeStringListCallback(/* w, list, call */);
extern void XswDestroyWidgetCallback(/* w, name, text */);
extern void XswDestroyWidgetAction(/* w, name, text */);

extern void XswExitProgramCallback(/* w */); 

extern String XswGetLibName(/*String name*/);
extern StringList XswLibDir(/*Widget w*/);
extern Widget XswTopWidget(/**/);

extern void XswInitConverters(/*Widget parent*/);
extern StringList XswSCPairListGetStrings(/* SCPairList */);

extern String XswGetExtension(/* file */);
extern Boolean XswLegalExtension(/* list, ext */);
extern Boolean XswCallFunction(/* list, ext, w, call_data */);
extern Boolean XswGetHelp(/* list, ext, w */);
extern StringList XswGetExtensions(/* list */);

extern StringSet XswInvert(/*StringSet set*/);
extern int XswCountStrings(/*StringList list*/);
extern void XswFreeStringList(/*StringList list*/);
extern StringList XswStringToStringList(/*String string*/);

void XswMakeRadioSet(/*Widget parent, String name*/);
void XswMakeCommandButtons(/*Widget box_w*/);
extern void  XswMakeSnapButtons();
void XswMakeRadioButtons(/*Widget box_w*/);
void XswMakeMenu(/*Widget parent, String name*/);

#define XswWidgetTool(name,tool,shell) \
{ \
  Widget shell = \
    XtCreatePopupShell(name, \
		       topLevelShellWidgetClass, XswTopWidget(), \
		       (ArgList) NULL, 0); \
  Widget tool_widget = ((Widget) tool); \
  if (tool_widget != (Widget) NULL) { \
    XswPopup(tool_widget,XtGrabNone,XswTopWidget(),XswRight); \
    XswGrabPointer((shell)); \
    XtOverrideTranslations((shell), \
      XtParseTranslationTable("<Message>WM_PROTOCOLS:XswDestroy()")); \
  } else { \
    XtDestroyWidget((shell)); \
  } \
}

/******************************************************************
 *
 * General Purpose Macros
 *
 *****************************************************************/


#define CVT_STRING_TO_LIST(_Name, _Type, _Resource, _End) \
/* ARGSUSED */ \
Boolean _Name(display, args, nargs, \
	      fromVal, toVal, converter_data) \
     Display* display; \
     XrmValuePtr args, fromVal, toVal; \
     int *nargs; \
     XtPointer* converter_data; \
{ \
  static _Type * result; \
  StringList list; \
  list = XswStringToStringList((String)fromVal->addr, " ,;"); \
  MAKE_LIST(result, _Type, _Resource, list, _End); \
  XswFreeStringList(list); \
  DONE(_Type *, result); \
}


#define MAKE_LIST(_result, _type, _resource, _slist, _end)\
{ \
  StringList _list = _slist; \
  int _n; \
  XrmValue _from, _to; \
  XtCacheRef _cache_ref_return; \
  int _i; \
  _n = XswCountStrings(_list); \
  _result = (_type *)XtMalloc((_n+1) * sizeof(_type)); \
  for(_i=0; _i < _n; _i++) { \
    _from.addr = _list[_i]; \
    _from.size = strlen(_list[_i]) + 1; \
    _to.addr = (XtPointer)&(_result[_i]); \
    _to.size = sizeof(_type); \
    XtConvertAndStore(XswTopWidget(), \
		      XtRString, &_from, _resource, &_to); \
  } \
  _result[_i] = (_end); \
}


/*      Macro Name: DONE.
 *      Description: Returns proper value from conversion routine.
 *      Arguments: type - the type of argument to return.
 *                 value - the value of the argument to return.
 */
#define DONE(type, value)\
{ \
  if (toVal->addr != NULL) {     \
    if (toVal->size < sizeof(type)) { \
	toVal->size = sizeof(type);   \
        return False;  \
    } \
    *(type*)(toVal->addr) = (value);  \
  } \
  else { \
    static type static_val;  \
    static_val = (value);  \
    toVal->addr = (XtPointer)&static_val;  \
  }   \
  toVal->size = sizeof(type);  \
  return True;  \
}


/*      Macro Name: ROOTWINDOW.
 *      Description: Returns the root window for a widget.
 *      Arguments: w - the Widget.
 */
#define ROOTWINDOW(w) \
  (RootWindow(XtDisplay(w),DefaultScreen(XtDisplay(w))))


/*      Macro Name: FONTHEIGHT.
 *      Description: Returns the height in pixels of a font.
 *      Arguments: font - the font to use.
 */
#define FONTHEIGHT(font) \
  ((font)->max_bounds.ascent+(font)->max_bounds.descent)


/*      Macro Name: SETDOUBLEARG.
 *      Description: Used like XtSetArg if arg is a double.
 *      Arguments: arg - the arg to set.
 *                 flag - the flag to use.
 *                 var - the double variable to place in arg.
 */
#define SETDOUBLEARG(arg, flag, var)  \
  if (sizeof(double) > sizeof(XtArgVal)) {\
	  XtSetArg(arg, flag, &(var)); \
	} else { \
	  XtArgVal * l_top = (XtArgVal *) &(var);\
	  XtSetArg(arg, flag, *l_top); \
	}


/*      Macro Name: MAX.
 *      Description: Returns the greater of two values.
 *      Arguments: a, b - the values to compare.
 */
#ifndef MAX
#define MAX(a,b) (((a) > (b)) ? (a) : (b))
#endif


/*      Macro Name: MIN.
 *      Description: Returns the lesser of two values.
 *      Arguments: a, b - the values to compare.
 */
#ifndef MIN
#define MIN(a,b) (((a) < (b)) ? (a) : (b))
#endif


/*      Macro Name: BOUND.
 *      Description: returns value is min <= value <= max.
 *                   if value < min then returns min.
 *                   if value > max then returns max.
 *      Arguments: value - the value to compare.
 *                 min - can't return a value lower than this.
 *                 max - can't return a value greter than this.
 */
#ifndef BOUND
#define BOUND(value, min, max) (MAX(MIN((value), (max)), (min)))
#endif


/*      Macro Name: LOWER_CASE.
 *      Description: returns a lower case ch.
 *      Arguments: ch - the letter whose lower case form is desired.
 */
#ifndef LOWER_CASE
#define LOWER_CASE(ch)   (((ch) >= 'A') && ((ch) <= 'Z') ? \
			   (ch) + ('a' - 'A') : (ch))
#endif 
