#ifndef _Xt_QuerySetP_h_
#define _Xt_QuerySetP_h_

#include "QuerySet.h"
#include <X11/ObjectP.h>

/**********************************************************
 * $Header: /tmp_mnt/ufs/pcn/carl/PCN/IF/Xsw/RCS/QuerySetP.h,v 1.2 91/09/13 17:01:43 carl Exp $
 *
 * Query Set Instance Data Structures
 *
 **********************************************************/
/******************************************************************************
*									      *
*	Copyright (C) The Aerospace Corporation 1991			      *
*									      *
*	This software was developed by The Aerospace Corporation as a 	      *
*	research endeavor for the United States Air Force 		      *
*	Space Systems Division.  The current version of the Gauge	      *
*	computer program is available for  release to you for		      *
*	educational and research purposes only.  It is not 		      *
*	to be used for commercial purposes.				      *
*									      *
*	In addition, the following conditions shall apply.		      *
*									      *
*	1) The computer software and documentation were designed to	      *
*	satisfy internal Aerospace requirements only.			      *
*	The software is provided ``as is,'' and The Aerospace Corporation     *
*	makes no warranty, expressed or implied, as to it accuracy,	      *
*	functioning, or fitness for a particular purpose.		      *
*									      *
*	2) The Aerospace Corporation and its personnel are not		      *
*	responsible for providing technical support or general assistance     *
*	with respect to the software.					      *
*									      *
*	3) Neither The Aerospace Corporation nor its personnel shall be	      *
*	liable for claims, losses, or damages arising out of or connected     *
*	with the use of this software.					      *
*	Your sole and exclusive remedy shall be to request a replacement      *
*	copy of the program.						      *
*									      *
******************************************************************************/


/* these fields match CorePart and can not be changed */

typedef struct _QuerySetPart {
  SCPairList names;
  Widget dir_w;
  Widget help_w;
  int current;
  StringList file_tags;

  Widget * query_w;
  StringList tags;
  StringList strings;
} QuerySetPart;

typedef struct _QuerySetRec {
    ObjectPart object;
    QuerySetPart querySet;
} QuerySetRec;



/********************************************************
 * Query Set Class Data Structures
 *
 ********************************************************/

typedef struct _QuerySetClassPart {

    WidgetClass   superclass;      /* pointer to superclass ClassRec   */
    String        class_name;      /* widget resource class name       */
    Cardinal      widget_size;     /* size in bytes of widget record   */
    XtProc        class_initialize;/* class initialization proc        */
    XtWidgetClassProc 
      class_part_initialize;       /* dynamic initialization      */
    XtEnum        class_inited;    /* has class been initialized?      */
    XtInitProc    initialize;    /* initialize subclass fields       */
    XtArgsProc    initialize_hook; /* notify that initialize called    */
    XtProc        objs1;	/* NULL                             */
    XtPointer     objs2;          /* NULL                             */
    Cardinal      objs3;         /* NULL                             */
    XtResourceList resources;    /* resources for subclass fields    */
    Cardinal      num_resources;  /* number of entries in resources   */
    XrmClass        xrm_class;    /* resource class quarkified        */
    Boolean         objs4;        /* NULL                      */
    Boolean         objs5;        /* NULL                       */
    Boolean         objs6;        /* NULL		   */
    Boolean         objs7;        /* NULL                             */
    XtWidgetProc    destroy;     /* free data for subclass pointers  */
    XtWidgetProc    objs8;     /* geom manager changed widget size */
    XtExposeProc    objs9;     /* rediplay rectangle               */
    XtSetValuesFunc set_values;  /* set subclass resource values     */
    XtArgsFunc   set_values_hook; /* notify that set_values called    */
    XtAlmostProc    objs10; /* set values almost for geometry   */
    XtArgsProc   get_values_hook; /* notify that get_values called    */
    XtProc          objs11;        /* NULL                             */
    XtVersionType   version;     /* version of intrinsics used       */
    XtPointer   callback_private;  /* list of callback offsets         */
    String          objs12;      /* NULL                             */
    XtGeometryHandler objs13; /* return preferred geometry   */
    XtProc          objs14;         /* NULL                          */
    XtPointer       extension;   /* pointer to extension record      */
} QuerySetClassPart;

typedef struct _QuerySetClassRec {
    QuerySetClassPart rect_class;
} QuerySetClassRec;

externalref QuerySetClassRec querySetClassRec;

#endif /*_Xt_QuerySetP_h_*/






