/*
 * $Header: /ufs/comp/mei/PROJ_PCN/onprofile/IFModel/Xsw/RCS/HelpP.h,v 1.1 1992/04/17 18:25:31 mei Exp $
 *
 * Private declarations for HelpWidgetClass
 */

/******************************************************************************
*									      *
*	Copyright (C) The Aerospace Corporation 1991			      *
*									      *
*	This software was developed by The Aerospace Corporation as a 	      *
*	research endeavor for the United States Air Force 		      *
*	Space Systems Division.  The current version of the Gauge	      *
*	computer program is available for  release to you for		      *
*	educational and research purposes only.  It is not 		      *
*	to be used for commercial purposes.				      *
*									      *
*	In addition, the following conditions shall apply.		      *
*									      *
*	1) The computer software and documentation were designed to	      *
*	satisfy internal Aerospace requirements only.			      *
*	The software is provided ``as is,'' and The Aerospace Corporation     *
*	makes no warranty, expressed or implied, as to it accuracy,	      *
*	functioning, or fitness for a particular purpose.		      *
*									      *
*	2) The Aerospace Corporation and its personnel are not		      *
*	responsible for providing technical support or general assistance     *
*	with respect to the software.					      *
*									      *
*	3) Neither The Aerospace Corporation nor its personnel shall be	      *
*	liable for claims, losses, or damages arising out of or connected     *
*	with the use of this software.					      *
*	Your sole and exclusive remedy shall be to request a replacement      *
*	copy of the program.						      *
*									      *
******************************************************************************/

#ifndef _HelpP_h
#define _HelpP_h

#include "Help.h"

#include <X11/ShellP.h>

typedef struct {int empty;} HelpClassPart;

typedef struct _HelpShellClassRec {
        CoreClassPart      core_class;
        CompositeClassPart composite_class;
        ShellClassPart  shell_class;
        WMShellClassPart   wm_shell_class;
        VendorShellClassPart vendor_shell_class;
        TransientShellClassPart transient_shell_class;
	HelpClassPart help_class;
} HelpClassRec;

extern HelpClassRec helpClassRec;

typedef struct _HelpPart {
  /* resources */
  StringSet help_set;

  /* private */
  Widget pane_w;
  Widget label_w;
  Widget text_w;
  Widget box_w;
} HelpPart;


typedef  struct _HelpRec {
        CorePart        core;
        CompositePart   composite;
        ShellPart       shell;
        WMShellPart     wm;
        VendorShellPart vendor;
        TransientShellPart transient;
	HelpPart help;
} HelpRec;

#endif /* _HelpP_h */
