#if ( !defined(lint) && !defined(SABER))
  static char PCN_rcsid[] = "$Header: /ufs/comp/carl/PCN/IF/Xsw/RCS/Error.c,v 1.3 1992/01/23 03:14:00 carl Exp $";
#endif

/******************************************************************************
*									      *
*	Copyright (C) The Aerospace Corporation 1991			      *
*									      *
*	This software was developed by The Aerospace Corporation as a 	      *
*	research endeavor for the United States Air Force 		      *
*	Space Systems Division.  The current version of the Gauge	      *
*	computer program is available for  release to you for		      *
*	educational and research purposes only.  It is not 		      *
*	to be used for commercial purposes.				      *
*									      *
*	In addition, the following conditions shall apply.		      *
*									      *
*	1) The computer software and documentation were designed to	      *
*	satisfy internal Aerospace requirements only.			      *
*	The software is provided ``as is,'' and The Aerospace Corporation     *
*	makes no warranty, expressed or implied, as to it accuracy,	      *
*	functioning, or fitness for a particular purpose.		      *
*									      *
*	2) The Aerospace Corporation and its personnel are not		      *
*	responsible for providing technical support or general assistance     *
*	with respect to the software.					      *
*									      *
*	3) Neither The Aerospace Corporation nor its personnel shall be	      *
*	liable for claims, losses, or damages arising out of or connected     *
*	with the use of this software.					      *
*	Your sole and exclusive remedy shall be to request a replacement      *
*	copy of the program.						      *
*									      *
******************************************************************************/
#include "Xsw.h"

#include <X11/Shell.h>
#include <X11/Xaw/Command.h>

static char * old_text = NULL;
static int error_cnt = 0;

void
XswDisplayWarnings(app_context)
XtAppContext app_context;
{
  Widget error_w, message_w;
  Arg args[5];
  void exit();
  
  if (old_text != NULL) {
    if (app_context == NULL) {
      error_w = XtCreateApplicationShell("Warning Message",
					 transientShellWidgetClass,
					 NULL, 0);
    } else {
      error_w = XtAppCreateShell("Warning Message", "Message", 
				 transientShellWidgetClass,
				 XswGetDisplay(app_context),
				 NULL, 0);
    }
    XtSetArg(args[0], XtNlabel, old_text);
    message_w = XtCreateManagedWidget("warning", commandWidgetClass,
				      error_w, args, 1);    
    XtAddCallback(message_w, XtNcallback, 
		  XswDestroyWidgetCallback, (XtPointer)message_w); 
    XtAddCallback(message_w, XtNdestroyCallback, 
		  XswDestroyWidgetCallback, (XtPointer)error_w);
    XswPositionWidget(message_w, NULL, XswMouse);
    XtPopup(error_w, XtGrabExclusive);
    XtFree(old_text);
    old_text = NULL;

    if (error_cnt > 0) {
      XtAddCallback(message_w, XtNdestroyCallback, 
		    exit, (XtPointer)NULL); 
      if (app_context == NULL) XswMainLoop();
      else XswAppMainLoop(app_context);
    }
  }
}

void
XswWarning(message)
     String message;
{
  static char header[] = "  Warning: ";
  String text;

  if (old_text == NULL) {
    old_text = (char *)XtMalloc(strlen(header) + strlen(message) + 8);
    sprintf(old_text, "\n%s%s  \n", header, message);
  } else {
    text = (char *)XtMalloc(strlen(old_text) + strlen(header)
			    + strlen(message) + 8);
    sprintf(text, "%s%s%s  \n", old_text, header, message);
    XtFree(old_text);
    old_text = text;
  }
}


void
XswError(message)
     String message;
{
  static char header[] = "  Error: ";
  String text;

  error_cnt++;
  if (old_text == NULL) {
    old_text = (char *)XtMalloc(strlen(header) + strlen(message) + 8);
    sprintf(old_text, "\n%s%s  \n", header, message);
  } else {
    text = (char *)XtMalloc(strlen(old_text) + strlen(header)
			    + strlen(message) + 8);
    sprintf(text, "%s%s%s  \n", old_text, header, message);
    XtFree(old_text);
    old_text = text;
  }
  XswDisplayWarnings(XswApplicationContext());
}



