/*
 * $Header: /tmp_mnt/ufs/pcn/carl/PCN/IF/Xsw/RCS/EntryP.h,v 1.2 91/09/13 17:01:14 carl Exp $
 *
 * Private declarations for EntryWidgetClass
 */

/******************************************************************************
*									      *
*	Copyright (C) The Aerospace Corporation 1991			      *
*									      *
*	This software was developed by The Aerospace Corporation as a 	      *
*	research endeavor for the United States Air Force 		      *
*	Space Systems Division.  The current version of the Gauge	      *
*	computer program is available for  release to you for		      *
*	educational and research purposes only.  It is not 		      *
*	to be used for commercial purposes.				      *
*									      *
*	In addition, the following conditions shall apply.		      *
*									      *
*	1) The computer software and documentation were designed to	      *
*	satisfy internal Aerospace requirements only.			      *
*	The software is provided ``as is,'' and The Aerospace Corporation     *
*	makes no warranty, expressed or implied, as to it accuracy,	      *
*	functioning, or fitness for a particular purpose.		      *
*									      *
*	2) The Aerospace Corporation and its personnel are not		      *
*	responsible for providing technical support or general assistance     *
*	with respect to the software.					      *
*									      *
*	3) Neither The Aerospace Corporation nor its personnel shall be	      *
*	liable for claims, losses, or damages arising out of or connected     *
*	with the use of this software.					      *
*	Your sole and exclusive remedy shall be to request a replacement      *
*	copy of the program.						      *
*									      *
******************************************************************************/

#ifndef _EntryP_h
#define _EntryP_h

#include "Entry.h"
#include <X11/Xaw/FormP.h>

typedef struct {int empty;} EntryClassPart;

typedef struct _EntryClassRec {
    CoreClassPart	core_class;
    CompositeClassPart	composite_class;
    ConstraintClassPart	constraint_class;
    FormClassPart	form_class;
    EntryClassPart	entry_class;
} EntryClassRec;

extern EntryClassRec entryClassRec;

typedef struct _EntryPart {
  /* resources */
  StringList labels;
  StringList defaults;
  XtCallbackList callback;

  /* private */
  int num_entries;
  int num_labels;
  Boolean exposed;
  StringList return_list;
  Widget * text_w;
} EntryPart;


typedef struct _EntryRec {
    CorePart	core;
    CompositePart	composite;
    ConstraintPart	constraint;
    FormPart		form;
    EntryPart	entry;
} EntryRec;


typedef struct {
    /* resources */
  int dummy;
} EntryConstraintsPart;

typedef struct _EntryConstraintsRec {
    FormConstraintsPart	form;
    EntryConstraintsPart	entry;
} EntryConstraintsRec, *EntryConstraints;

#endif /* _EntryP_h */


