#if ( !defined(lint) && !defined(SABER))
  static char PCN_rcsid[] = "$Header: /ufs/comp/mei/PROJ_PCN/onprofile/IFModel/Xsw/Callbacks.c,v 1.1 1992/04/17 18:21:13 mei Exp $";
#endif

/******************************************************************************
*									      *
*	Copyright (C) The Aerospace Corporation 1991			      *
*									      *
*	This software was developed by The Aerospace Corporation as a 	      *
*	research endeavor for the United States Air Force 		      *
*	Space Systems Division.  The current version of the Gauge	      *
*	computer program is available for  release to you for		      *
*	educational and research purposes only.  It is not 		      *
*	to be used for commercial purposes.				      *
*									      *
*	In addition, the following conditions shall apply.		      *
*									      *
*	1) The computer software and documentation were designed to	      *
*	satisfy internal Aerospace requirements only.			      *
*	The software is provided ``as is,'' and The Aerospace Corporation     *
*	makes no warranty, expressed or implied, as to it accuracy,	      *
*	functioning, or fitness for a particular purpose.		      *
*									      *
*	2) The Aerospace Corporation and its personnel are not		      *
*	responsible for providing technical support or general assistance     *
*	with respect to the software.					      *
*									      *
*	3) Neither The Aerospace Corporation nor its personnel shall be	      *
*	liable for claims, losses, or damages arising out of or connected     *
*	with the use of this software.					      *
*	Your sole and exclusive remedy shall be to request a replacement      *
*	copy of the program.						      *
*									      *
******************************************************************************/

#include "Xsw.h"
#include "Callbacks.h"

static Boolean CvtStringToCallback();

typedef struct callbackstruct callback;

struct callbackstruct {
  XtCallbackProc function;
  char * name;
  callback * next;
  XtPointer data;
};

static callback * GetCallback();

static callback Callbacks = {
  NULL, NULL, NULL, NULL };

void XswRegisterCallback(name, function, data)
char * name;
XtCallbackProc function;
XtPointer data;
{
  callback * call;

  if (Callbacks.next == NULL) {
    XtSetTypeConverter(XtRString, XtRCallback,
		       CvtStringToCallback, NULL, 0,
		       XtCacheNone, NULL); 
  }
  
  call = GetCallback(name);
  if (call == NULL) {
    call = &Callbacks;
    while (call->next != NULL) call = call->next;
    call->next = (callback *)XtMalloc(sizeof(callback));
    call->next->function = function;
    call->next->name = name;
    call->next->data = data;
    call->next->next = NULL;
  } else {
    call->function = function;
    call->data = data;
  }
}

static callback *
  GetCallback(name)
char * name;
{
  callback * call;  

  call = &Callbacks;
  while (call->next != NULL) {
    if (!strcmp(call->next->name, name)) 
      return call->next;
    call = call->next;
  }
  return NULL;
}

   
/* ARGSUSED */
static Boolean
  CvtStringToCallback(display, args, nargs,
		      fromVal, toVal, converter_data)
Display* display;
XrmValuePtr args, fromVal, toVal;
int *nargs;
XtPointer* converter_data;
{
  static XtCallbackRec *callback_list;
  callback * call;

  call = GetCallback((char *)fromVal->addr);
  if (call == NULL) {
    XtStringConversionWarning((char *) fromVal->addr, "Callback");
    return False;
  }
  else {
    callback_list = (XtCallbackRec *)XtCalloc(2, sizeof(XtCallbackRec));
    callback_list[0].callback = call->function;
    callback_list[0].closure = call->data;
    callback_list[1].callback = (XtCallbackProc) NULL;
    callback_list[1].closure = (XPointer) NULL;
    DONE(XtCallbackRec *, callback_list);
  }
}





