/* "$Header: /ufs/comp/mei/TestPCN/onprofile/IFModel/Model/RCS/modeldef.h,v 1.1 1992/02/26 18:53:40 mei Exp $" */
/********************************************************/
/* File: model.h                                        */
/* Content: global definitions for cuounter file's      */
/*   internal manipulation                              */
/* Date 2/1992                                          */
/********************************************************/

/* AERO_MESG */
#ifndef _MODEL_H
#define _MODEL_H

#include <stdio.h>
#include <sys/param.h>

#ifndef _GAUGE_H
#include "gauge.h"
#endif

#undef TIMER /* Don't use the definition of timer in gauge.h */

#define TRUE     1
#define FALSE    0

#define CURRENT_COUNTER_VERSION 0005
#define CURRENT_MODEL_VERSION 0005

#define TABLE_SIZE 1023		/* Hash table size */
#define MAX_NAME 50		/* Maximum size of procedure name */
#define MAX_SELECT 100		/* Maximum number of selections  */
#define FMT_SIZE 1096

/* line types allowed in model file */

#define PCN_PARALLEL 'P'
#define PCN_IMPLICATION 'I'
#define FOREIGN_PROCEDURE 'F'
#define CLAUSE 'C'
#define COUNTER 'K'
#define TIMER 'T'
#define NODES 'N'
#define PER_NODE_STATS 'P'
#define MODULE 'M'
#define CALL_GRAPH 'G'
#define VERSION 'V'
#define START 'S'
#define END 'E'
#define GUARD_STATS 'B'
#define UNKNOWN '?'

#define CALIBRATE 0x1
#define WRITE 0x2
#define DISPLAY 0x3

/* View definitions */
#define VTIME 'T'
#define VFREQ 'F'
#define VIDLE 'I'
#define VMSGCNTS 'C'
#define VMSGVOL 'V'

/* for ModelStruct structure */
#define INSTR_CLASSES 2

#define SWAP_COUNTERS 0
#define SWAP_TIMERS 1

/* 12/30 hui define last snapshot's snapname */
#define LASTSNAP  "end"
#define LAST      -1

#define Free(c) free((char *) (c))

/********************************************************/
/* global data structures                               */ 
/********************************************************/

#ifndef HISTOGRAM 
typedef char *String;
typedef int Widget;
#endif

#ifdef HISTOGRAM
typedef struct ListElementStruct {
  String label;
  void * pointer;
  Boolean state;
} ListElement;
#endif

typedef struct BucketStruct {
  char *key;
  char *value;
  struct BucketStruct *next;
  } HBucket;

struct s_clausecounts {
  unsigned long use;
  unsigned long failure;
  unsigned long commit;
} /*counts*/;

typedef struct ClauseProfileStruct {
  int snap_no; 
  int node_no;
  struct ClauseStruct *clau_ptr;    /*pt back to parent clause*/
  struct s_clausecounts counts;
  struct {
    float success;
    float failure;
  } cost;
  struct ClauseProfileStruct *next; 
} ClauseProfileData;

typedef struct ProcedureProfileStruct {
  int snap_no;
  struct ProcedureStruct *proc_ptr; /* pt back to head procedure */
  struct {
    unsigned long use;
    unsigned long failure;
    unsigned long commit;
    unsigned long suspend;
    unsigned long copy;
  } counts;
  struct {
    float success;
    float failure;
    float suspend;
    float total;
    float idle;
  } cost;
  struct ProcedureProfileStruct *next; 
}ProcedureProfileData;

typedef struct ModelStruct {
  float failure[INSTR_CLASSES];
  float success[INSTR_CLASSES];
}ClauseModel;

typedef struct ForeignStruct {
  struct ProcedureStruct *procedure;
  int timer;
}Foreign;

typedef struct ClauseStruct {
  int body_goals;
  int commit_offset;
  ClauseModel model;
  struct ProcedureStruct *proc_ptr; /* pt back to proc */
  struct ProcedureStruct **calls;
  struct ForeignStruct *foreigns;
                        /*clause profile data -fix array [node_no] */
  struct TableHeaderStruct *claupernode;
}Clause;

typedef struct GraphStruct {
  Clause *clause_ptr;
  struct GraphStruct *next;
}RGraph;

typedef struct SnapTableEntryStruct {
  int node_no;
  ProcedureProfileData *procprofile;            /*data ptr*/
  struct SnapTableEntryStruct *next_snap_entry; /*same node_no*/
  struct SnapTableEntryStruct *next_node_list;
}SnapTableEntry;

typedef struct TableHeaderStruct { 
  int tbl_cnt;
  void *data_ptr;
}TableHeader;

/** Procedure.total is total profile data per procedure summing
      across all the nodes **/

typedef struct ProcedureStruct {
  char *name;
  struct ModuleStruct *mod_ptr;  /* pt back to originaal module */
  int arguments;
  int size;
  int visible;
  struct { int idle, copy, suspend; } offsets;
  int id;/* sequential id number assigned as procedures are allocated */
  int type;
  ProcedureProfileData *total; /*Fix Array [snapshot]*/
                      /* procedure profile data - fix array [node_no] */
  TableHeader *procpernode;
  RGraph *callers;
  Clause clauses[1];/* list of clauses in a procedure */
} Procedure;

typedef struct node_stats {
  int used;
  int mins,secs,msecs;
  int idle_mins,idle_secs,idle_msecs;
  int gc_mins, gc_secs, gc_msecs;
  int gc_count;
  unsigned long reductions, suspensions;
  long send_small, send_big, send_length;
  long rcv_small, rcv_big, rcv_length;
}NodeStats;

typedef void (*swapfunc)();

struct cost_parameters {
  float classtype[INSTR_CLASSES];
  float suspend, copy;
  float send_small, send_big, send_length;
  float rcv_small, rcv_big, rcv_length;
};

struct arch_descriptor {
  struct {int low, hi; } node_range;
  struct cost_parameters parameters;
  char host_name[MAXHOSTNAMELEN];
  swapfunc byte_swapper;
  int ticks_per_second;
};

/** the total is the summing of profile data per node across
    all procedures     */
typedef struct NodeStruct {
  struct { char *pattern;
	   float value;
	   char label[sizeof("Processor xxxx")];} bar;
  ProcedureProfileData *total; /* Fix Array[snapshot] */
  struct arch_descriptor *machine;
  int node_no;
  struct node_stats *stats; /* Fix array of stats [snapshot]*/
} Node;

typedef struct ModuleStruct {
  char *name;
  HBucket *procedures[TABLE_SIZE];
        /*snapshot link-up table, fix array [snap_cnt]*/
  TableHeader *snaptable; 
  int ncounters, ntimers;
} Module;

typedef struct SnapNameStruct {
  char name[MAX_NAME];       /* the snapname list */
}SnapName;

typedef struct global_info {
  int mins,secs,msecs;
  unsigned long reductions, suspensions;
  int node_cnt,         /* Total number of nodes */
      first_node,       /* first node idx for nodes */
      last_node;        /* last node idx for nodes */
  int procedure_cnt;    /* Total number of procedures */
  int snap_cnt;         /* Total number of snapshots */
  int module_cnt;       /* Total number of modules */
  struct SnapNameStruct *snap;
}GlobInfo;

typedef struct curr_stats {/*used as temporary space for ppshow*/
  int gc_mins, gc_secs, gc_msecs;
  int gc_count;
  long send_small, send_big, send_length;
  long rcv_small, rcv_big, rcv_length;
}CurrStats;

typedef struct curr_info {/*used as temporary by "subset" in ppshow*/
  int node_cnt;            /* current node_cnt */
  int procedure_cnt;       /* current procedure_cnt */
  int module_cnt;          /* current module_cnt */
  int snap_cnt;            /* current snap_cnt */
  int order;               /* current sort order */
}CurrInfo; 

typedef struct HistoStruct {
  char *filename;     /* file to retrieve dat from */
  char *title;        /* title of the tool using this database */
#ifdef HISTOGRAM
  Widget help;
  String help_key;
  int subset;
  Widget view;        /* pt to parent Widget calling ppshow */
  ListElement *vnodes;  /* Array of nodes */
  ListElement *procs;   /* Array of pointers to procedures */
    /* follow the hashing order in module and proc taables */
#endif /* HISTOGRAM */
  GlobInfo  info;
  CurrStats currstats;
  CurrInfo  curr;
  Node *nodes;			/* Array of nodes */
  int machine_types;
  struct arch_descriptor *architecture;
  HBucket *modules[TABLE_SIZE];
} Histo;

union u_bytecode_key { /* used in byte_swapper + hutil */
  char bytes[8];
  gauge_timer timer;
};

typedef struct AssignArgStruct{
        Histo *hPtr;
        int snap_cnt;
        char *buff,*snapname;
        ProcedureProfileData *snapPtr;
        int snap_no;
        int node_no;
} AssignArg;

/********************************************************/
/* global variable declared as external for calls from  */
/* other than model.c                                   */
/* Date: 2/1992                                         */
/********************************************************/

extern char TextBuffer[FMT_SIZE];     /* temporary text buffer */
extern char MessageBuffer[FMT_SIZE];  /* temporary message buffer */

/********************************************************/
/* predeclaration of some routines                      */
/********************************************************/

/* from byte_swapper.c */
extern    swapfunc decode_byteorder_key();
/* from tables.c */
extern    void initialize_procpernode();
extern    void initialize_clausepernode();
extern    Procedure *find_procedure();
extern    Module *find_module();
extern    Module *lookup_module();
extern    char *map_procedures();
extern    char *map_table();
extern    ProcedureProfileData *lookup_procsnapprof();
extern    ProcedureProfileData *insert_procsnapprof();
extern    ClauseProfileData *lookup_clausnapprof();
extern    ClauseProfileData *lookup_clausnapprof2();
extern    ClauseProfileData *insert_clausnapprof();
/* from hutil.c */
extern    char *checkmalloc();
extern    int free_module();
/* from snaparrays.c */
extern    void init_all_snapFixArray();
extern    char *init_snaptable();
extern    char *init_a_proc_total();

#endif /* _MODEL_H */
