
/**************************************************************/
/**************************************************************/
/** this is only used for the data retrieval part of display **/
/** not valid for compiling with ppshow or the with X        **/
/** routines, the corresponding routines for ppshow is under **/
/** the file of ppshow.c                                     **/
/**************************************************************/
/**************************************************************/

#include <stdio.h>

#ifndef _PPSHOW_H
#include "ppshow.h"
#endif

#ifdef HISTOGRAM 
#include "Xsw/Xsw.h" 
#include "Xsw/Help.h" 
#include <X11/Shell.h> 
  
#include "Gauge/Viewer.h"
#endif /* HISTOGRAM */ 

     /* from ppshow.c but not really used */
struct cost_parameters Parameters; 

char *checkmalloc(size,procname)
     int size;
     char *procname;
{
  char *calloc();
  char *ptr = (char *) calloc((unsigned) 1,(unsigned) size);
  if (ptr == NULL) {
    sprintf(TextBuffer,"Malloc failed in %s",procname);
    GaugeError("checkmalloc",TextBuffer);
  } else
    return ptr;
}

GaugeError(procname,str)
     char *procname,*str;
{
sprintf(MessageBuffer,"%s -%s\n",procname,str);
#if (HISTOGRAM)
  if (ModeFlag == DISPLAY) {
    XtWarning(MessageBuffer);
    exit(1);
/*longjmp(ErrorEnv,1); */
  } else {
    printf(MessageBuffer);
    exit(1);
  }
#else
  printf(MessageBuffer);
  exit(1);
#endif
}

GaugeWarning(procname,str)
     char *procname,*str;
{
sprintf(MessageBuffer,"%s -%s\n",procname,str);
#if (HISTOGRAM)
  if (ModeFlag == DISPLAY)
    XtWarning(MessageBuffer);
  else
    printf(MessageBuffer);
#else
  printf(MessageBuffer);
#endif
}


/* ARGSUSED */
load_arch_dbase(hPtr,arch)
     Histo *hPtr;
     struct arch_descriptor *arch;
{
  char buf[256];
  char hostname[MAXHOSTNAMELEN];

  typedef struct {
    String dbase_file;
    String default_arch;
  } ArchData, *ArchDataPtr;

#ifdef HISTOGRAM
  static XtResource arch_resources[] = {
    { "archDbase", "ArchDbase", XtRString, sizeof (String),
	XtOffset(ArchDataPtr, dbase_file), XtRString, 
	DEFAULT_ARCH_DBASE },
    { "archDefault", "ArchDefault", XtRString, sizeof (String),
	XtOffset(ArchDataPtr, default_arch), XtRString, 
	DEFAULT_ARCH },
  };
#endif
  ArchData data;
  FILE *fd;

#if (DEFAULT_ARCH)
  data.default_arch = DEFAULT_ARCH;
#else
  data.default_arch=(String) checkmalloc(sizeof("sun4")+1,"load_arch_dbase");
  strcpy(data.default_arch,"sun4");
#endif

#if (DEFAULT_ARCH_DBASE)
  data.dbase_file = DEFAULT_ARCH_DBASE;
#else
  data.dbase_file=(String) checkmalloc(sizeof("pcn_hosts")+1,"load_arch_dbase");
  strcpy(data.dbase_file,"pcn_hosts");
#endif

#ifdef HISTOGRAM
  if (ModeFlag == DISPLAY) {
    XtGetApplicationResources(hPtr->view, &data, arch_resources, 
			      XtNumber(arch_resources), NULL, 0);
    data.dbase_file = XswGetLibName(data.dbase_file);
  }
#endif /* HISTOGRAM */

  fd = fopen(data.dbase_file,"r");
  if (fd == NULL) {
    sprintf(TextBuffer,"Could not open architecture parameter file");
    GaugeError("load_arch_dbase",TextBuffer);
    return;
  }

  strcpy(hostname,arch->host_name);

  lookup:
  while (fscanf(fd,"%s",buf) != EOF) {
    if (buf[0] == '+' && buf[1] == '>')
      { /* A reference line */
	fscanf(fd," %s ",buf);
	if (! strncmp(buf,hostname,strlen(buf)) ) {
	  /* Get name of hostype being referenced */
	  fscanf(fd," %s ",hostname);
	  /* Now resolve it */
	  rewind(fd);
	  continue;
	}
      }
    else if  ( (buf[0] == '-' && buf[1] == '-') ||
	      strncmp(buf,hostname,strlen(buf)) )
      fscanf(fd,"%*[^\n]");
    else  {
      int i, tmp;
      union u_bytecode_key key;

      sprintf(TextBuffer+strlen(TextBuffer),
	      "  Using architectural parameters for %s\n\n",buf);

      /* Get byteorder key */
      for (i = 0 ; i < 8 ; i++) {
	fscanf(fd," %2x ",&tmp);
	key.bytes[i] = tmp;
      }
      arch->byte_swapper = decode_byteorder_key(key.timer);

      /* Get the number of clock ticks per second */
      fscanf(fd," %d ",&(arch->ticks_per_second));
      /* Finally, get the instruction parameters */
      if (ModeFlag == CALIBRATE) {
	int i;
	for (i = 0 ; i < INSTR_CLASSES ; i++)
	  arch->parameters.classtype[i] = 1.0;
	arch->parameters.suspend = arch->parameters.copy = 1.0;
	arch->parameters.send_small = arch->parameters.send_big =
	  arch->parameters.send_length = 1.0;
	arch->parameters.rcv_small = arch->parameters.rcv_big =
	  arch->parameters.rcv_length = 1.0;
      } else {
	for (i = 0 ; i < INSTR_CLASSES ; i++) 
	  fscanf(fd," %f ",(arch->parameters.classtype)+i);
	fscanf(fd," %f ",&(arch->parameters.suspend));
      }
      fclose(fd);
      return;
    }
  }

  sprintf(TextBuffer,
	  "Architectural parameters for host:\n    %s\n  are not defined.\n\
  Using parameters for %s instead\n  Use the \"pcnhost\" command to  \n  add\
 this host to the architecture database",
	  arch->host_name,data.default_arch);
  GaugeWarning("load_arch_dbase",TextBuffer);
  rewind(fd);
  strcpy(hostname,data.default_arch);
  goto lookup;
}

