#if (!defined(lint) && !defined(SABER))
static char *rcsid = "$Header: /tmp_mnt/ufs/pcn/carl/PCN/V1.2/IF/Model/RCS/main.c,v 1.4 91/10/08 11:48:19 carl Exp $";
#endif

/*AEROMESG*/

#include <stdio.h>
#include <strings.h>
#include <math.h>

#ifdef HISTOGRAM
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Toggle.h>
#endif /* HISTOGRAM */

#ifdef sequent
#define MAXFLOAT HUGE
#else
#ifdef NeXT
#else
#ifdef sun
#include <values.h>
#endif /* sun */
#endif /* NeXt */
#endif /* sequent */

#ifndef _MODEL_H
#include "model.h"
#endif

#ifdef HISTOGRAM
#include <Xsw/Xsw.h>
#include <Gauge/Viewer.h>
#endif

#define NODE_DISPLAY(mode) ((mode) != ALL && (mode) != NODE)

#ifdef HISTOGRAM
void QuitXpert(w,client,call)
     Widget w;
     XtPointer client;
     XtPointer call;
{ 
  exit(0);
}

/* ARGSUSED */
void 
QuitXpertAction(w, event, params, num_params)
     Widget w;
     XEvent *event;
     String *params;
     int num_params;
{
  QuitXpert(w,NULL,NULL); 
}

#endif

main (argc, argv)
    int argc;
    char *argv[];
{

  int flag = WRITE;
  char c;
  int errflg = 0;
  int optind = 1;
  char *optarg;
  char *calculate_pcn_measurements(), *calculate_foreign_measurements();
  char *execution_time(), *print_time();
  extern double atof();

#ifdef HISTOGRAM
  Widget toplevel;
  XtAppContext context;
  void QuitXpert(), QuitXpertAction();
  static XtActionsRec window_actions[] = {
    { "QuitXpert", QuitXpertAction },
  };
  flag = DISPLAY;
#endif

  while (optind < argc && (optarg = argv[optind], *(optarg++) == '-')) {
    optind++;
    c = *(optarg++);
    switch (c) {
    case 'c':
      flag = CALIBRATE;
      break;
    case 'w':
      flag = WRITE;
      break;
#ifdef HISTOGRAM
    case 'd':
      flag = DISPLAY;
      break;
#endif
    case '?':
      errflg++;
    }
  }
  if (errflg) {
    fprintf(stderr, "usage: model [-p success failure suspend -c -o ofiles]\n");
    exit(2);
  }
  

  if (optind < argc) {
#ifdef HISTOGRAM
    if (flag == DISPLAY) {
      toplevel = XtAppInitialize(&context, "Xpcn", NULL, 0, &argc, argv, NULL, NULL, 0);

      XtAppAddActions(context, window_actions, XtNumber(window_actions));
      XswInitialize(toplevel);

      XswRegisterCallback("QuitXpert",QuitXpert,NULL);
      XtOverrideTranslations(toplevel, 
			     XtParseTranslationTable("<Message>WM_PROTOCOLS:XswDestroy()"));
    }
#endif

#ifdef HISTOGRAM
#include <X11/Shell.h>
    XswWidgetTool("GaugeDisplay",ppshow(shell, argv[optind], 3),shell); 
    if (flag == DISPLAY ) {
      XswAppMainLoop(context);
    }
#else
    ppshow(0,argv[optind],flag); 
#endif
  }
  else {
    sprintf(TextBuffer,"Need to specify a counter file");
    GaugeError("main",TextBuffer);
    exit(1);
  }
}

