
#if (!defined(lint) && !defined(SABER))
static char *rcsid = "$Header: /ufs/comp/mei/TestPCN/onprofile/IFModel/RCS/byte_swapper.c,v 1.1 1991/12/11 22:19:59 mei Exp $";
#endif

/*AERO_MSGE*/

#include <stdio.h>
#ifdef HISTOGRAM
#include <Xsw/Xsw.h>
#include <Gauge/Gauge.h>
#endif
#ifndef _MODEL_H
#include "model.h"
#endif

/*
 * Figure out what swapping function we need to convert a
 * gauge_timer output in binary from PCN into a gauge_timer
 * on the machine running gauge
 */
swapfunc decode_byteorder_key(timer)
gauge_timer timer;
{
    void swap1234_5678();
    void swap4321_8765();
    union u_bytecode_key key, test_key;
    
    key.timer = timer;
    
    test_key.timer.low_word = 0x01020304;
    test_key.timer.hi_word = 0x05060708;
    
    if (test_key.bytes[0]==key.bytes[0] && test_key.bytes[1]==key.bytes[1] &&
	test_key.bytes[2]==key.bytes[2] && test_key.bytes[3]==key.bytes[3] &&
	test_key.bytes[4]==key.bytes[4] && test_key.bytes[5]==key.bytes[5] &&
	test_key.bytes[6]==key.bytes[6] && test_key.bytes[7]==key.bytes[7])
    {
	return swap1234_5678;
    }
    else
    if (test_key.bytes[0]==key.bytes[3] && test_key.bytes[1]==key.bytes[2] &&
	test_key.bytes[2]==key.bytes[1] && test_key.bytes[3]==key.bytes[0] &&
	test_key.bytes[4]==key.bytes[7] && test_key.bytes[5]==key.bytes[6] &&
	test_key.bytes[6]==key.bytes[5] && test_key.bytes[7]==key.bytes[4])
    {
	return swap4321_8765;
    }
    else
    {
	printf("Unknown byte ordering\n");
	return swap1234_5678;
    }
}


void swap_general(counters,ncounters,type,ticks_per_second, b3, b2, b1, b0)
unsigned long *counters;
int ncounters, type, ticks_per_second;
int b3, b2, b1, b0;
{
    int i;
    union {
	unsigned char bytes[4];
	unsigned long word;
    } counter;
    
    if (type == SWAP_TIMERS)
    {
	gauge_timer *tPtr = (gauge_timer *) counters;
	double *dPtr = (double *) counters;
	
	for (i = 0; i < ncounters ; i++)
	{
	    counter.word = (tPtr+i) -> low_word;
	    (tPtr+i)->low_word =
		((((counter.bytes[b3] * 256) + counter.bytes[b2]) * 256) + 
		 counter.bytes[b1]) * 256 + counter.bytes[b0];
	    counter.word = (tPtr+i) ->hi_word;
	    (tPtr+i)->hi_word =
		((((counter.bytes[b3] * 256) + counter.bytes[b2]) * 256) + 
		 counter.bytes[b1]) * 256 + counter.bytes[b0];
	    timer_secs(tPtr[i], ticks_per_second, dPtr+i);
	}
    }
    else
    {
	for (i = 0; i < ncounters ; i++)
	{
	    counter.word = counters[i];
	    counters[i] = 
		((((counter.bytes[b3] * 256) + 
		   counter.bytes[b2]) * 256) + 
		 counter.bytes[b1]) * 256 +
		     counter.bytes[b0];
	    
	}
    }
} /* swap_general() */


void swap1234_5678(counters, ncounters,type,ticks_per_second)
unsigned long *counters;
int ncounters, type, ticks_per_second;
{
    swap_general(counters, ncounters, type, ticks_per_second, 0, 1, 2, 3);
}

void swap4321_8765(counters,ncounters,type,ticks_per_second)
unsigned long *counters;
int ncounters, type, ticks_per_second;
{
    swap_general(counters, ncounters, type, ticks_per_second, 3, 2, 1, 0);
}

/*ARGSUSED*/
timer_secs(timer, ticks_per_sec, seconds)
gauge_timer timer;
int ticks_per_sec;
double *seconds;
{
    double scale;
    unsigned long utmp = 0xFFFFFFFF;
    scale = (((double) utmp) + 1) / ticks_per_sec;
    *seconds = (((double) timer.hi_word) * scale);
    *seconds += ((double) timer.low_word) / ticks_per_sec;
} /* timer_secs() */
