/*
 * Please note that this code is the property of
 * the University of Melbourne and is Copyright 1985 by it.
 * 
 * All rights are reserved.
 */

% Contains a set of assert/retract/clause/listing primitives
% which dont interact with existing code.
% (useful for preprocessors for system code etc)
% Each predicate has the same name as the standard version
% with a '2' appended on the end: assert2, asserta2, getclause2,...
% Only the single argument version of listing2 is implemented.
%
% The code is the same as sys/atoms.nl and sys/listing.nl
% except for the name changes and removal of calls to $makeDynamic.

%	The assert2, retract2, retractall2/2 and clause predicates call $-prefixed
%	versions of themselves.  This is to make the kind of additions
%	that the database systems like to make to these predicates easy.
% There is no point doing this here since the db system uses assert etc,
% but I havent got around to changing it.

clauses2(Pred, Arity, Clauses) :-
	properties(Pred, $clause2(Arity), Clauses).

%	Memory efficient version of
%		clauses2(Pred, Arity, Clauses), member(Clause, Clauses).
getclause2(Pred, Arity, Clause) :-
	getclause2(Pred, Arity, Clause, _Ref).

getclause2(Pred, Arity, Clause, Ref) :-
	$rawProperties(Pred, $clause2(Arity), RawClauses),
	Ref = $ref(P, I),
	member($prop(_, P, I), RawClauses),
	instance(Ref, _Key, Clause).

$asserta2(Clause, Ref) :-
	(var(Clause) -> sys$error(warning, "Variable to asserta2/1"), fail),
	(Clause = (Head :- _Body)
	->	(var(Head) -> sys$error(warning, "Variable head to asserta2/1"), fail),
		functor(Head, Atom, Arity),
%		$makeDynamic(Atom, Arity),
		addpropa(Atom, $clause2(Arity), Clause, Ref)
	;	functor(Clause, Atom, Arity),
%		$makeDynamic(Atom, Arity),
		addpropa(Atom, $clause2(Arity), (Clause :- true), Ref)
	).

asserta2(X) :-
	$asserta2(X, _Ref).

asserta2(X, Ref) :-
	$asserta2(X, Ref).

$assertz2(Clause, Ref) :-
	(var(Clause) -> sys$error(warning, "Variable to assertz2/1"), fail),
	(Clause = (Head :- _Body)
	->	(var(Head) -> sys$error(warning, "Variable head to assertz2/1"), fail),
		functor(Head, Atom, Arity),
%		$makeDynamic(Atom, Arity),
		addpropz(Atom, $clause2(Arity), Clause, Ref)
	;	functor(Clause, Atom, Arity),
%		$makeDynamic(Atom, Arity),
		addpropz(Atom, $clause2(Arity), (Clause :- true), Ref)
	).

assertz2(X) :-
	$assertz2(X, _Ref).

assertz2(X, Ref) :-
	$assertz2(X, Ref).

assert2(X) :-
	assertz2(X, _Ref).

assert2(X, Ref) :-
	assertz2(X, Ref).

$retract2(Clause) :-
	(var(Clause) -> sys$error(warning, "Variable to retract2/1"), fail),
	(Clause = (Head :- _)
	->	(var(Head) -> sys$error(warning, "Variable head to retract2/1"), fail),
		$iretract2(Clause)
	;	$iretract2((Clause :- _))
	).

retract2(Clause) :-
	$retract2(Clause).

$iretract2(Clause) :-
	Clause = (Head :- _),
	functor(Head, Atom, Arity),
	$proplist(Atom, PropList),
	member($prop($clause2(Arity), P, I), PropList),
	instance($ref(P, I), _, Clause),
	erase($ref(P, I)).

%	Retract all the interpreted clauses for Pred/Arity.
%	Much faster than (retract2(_), fail).
$retractall2(Pred, Arity) :-
	(\+ atom(Pred)
	->	sys$error(warning, 'Atom expected in retractall2/2'),
		fail
	),
	(\+ integer(Arity)
	->	sys$error(warning, 'Integer expected in retractall2/2'),
		fail
	),
	remprop(Pred, $clause2(Arity)).

retractall2(Pred, Arity) :-
	$retractall2(Pred, Arity).

retractall2(Term) :-
	retract2(Term),
	fail.
retractall2(_).

%	Backtrack over the clauses matching Head.
%	Error checking (and delaying?) needed.
$clause2(Head, Body, Ref) :-
	functor(Head, Pred, Arity),
	getclause2(Pred, Arity, (Head :- Body), Ref).

clause2(Head, Body) :-
	$clause2(Head, Body, _Ref).

clause2(Head, Body, Ref) :-
	$clause2(Head, Body, Ref).

listing2(X) :-
	\+ ground(X),
	!,
	sys$error(warning, "Non-ground argument to listing2/1"),
	fail.
listing2(Atom) :-
	atom(Atom),
	!,
	\+ (currentPredicate(Atom, Arity), $listing2(Atom, Arity), fail).
listing2(Pred/Arity) :-
	atom(Pred), integer(Arity),
	!,
	$listing2(Pred, Arity).
listing2(List) :-
	isList(List),
	!,
	\+ (member(X, List), listing2(X), fail).

$listing2(Pred, Arity) :-
	nl,
	\+ (getclause2(Pred, Arity, Clause),
		portraycl(Clause), writeln(.), fail).
