/* $Id: port.c,v 1.42 1993/10/15 15:15:14 bd Exp $ */

#include "include.h"
#include "term.h"
#include "tree.h"
#include "predicate.h"
#include "exstate.h"
#include "engine.h"
#include "storage.h"
#include "unify.h"
#include "copy.h"
#include "gc.h"
#include "initial.h"
#include "config.h"
#include "display.h"
#include "error.h"
#include "names.h"

Gvainfo newport();
bool 	unifyport();
int 	printport();
Gvainfo	copyport();
Gvainfo	gcport();
int     uncopiedport();
envid	*deallocateport();
int	killport();
bool	closeport();


typedef struct port {
  gvamethod	*method;
  envid 	*env;
  Term 		stream;
} port;


static gvamethod portmethod = {
  newport,
  unifyport,
  printport,
  copyport,
  gcport,
  uncopiedport,  
  deallocateport,
  killport,
  closeport,
  NULL,
  NULL,
  NULL
};


#define IsPort(Prt) (IsCvaTerm(Prt) && \
		     RefCvaMethod(Ref(Prt)) == &portmethod)

#define GvaPort(g)	((port*)(g))
#define Port(x)		GvaPort(RefGva(Ref(x)))


predicate *send3_def;


Gvainfo newport(old)
     port *old;
{
  port *new;
  NEW(new,port);
  return (Gvainfo) new;
}

Gvainfo copyport(old,new)
     port *old, *new;
{
  new->stream = old->stream;
  copy_location(&new->stream);
  return (Gvainfo) new;
}

Gvainfo gcport(old,new,gcst)
     port *old, *new;
     gcstatep gcst;
{
  new->stream = old->stream;
  gc_location(&new->stream,gcst);
  return (Gvainfo) new;
}


envid *deallocateport(prt)
     Gvainfo prt;
{
  register Term s;
  s = GvaPort(prt)->stream;
  while (IsREF(s)) {
    if (IsCopied(Ref(s))) {
      break;
    } else if (IsUnBoundRef(Ref(s))) {
      return NULL;
    }
    s = RefTerm(Ref(s));
  }
  /* Environment dereferencing is done by gc. */
  return prt->env;
}

bool closeport(Arg)
     Argdecl;
{
  Term X0;
  Term point;
  
  X0 = A(0);

  Deref(point, Port(X0)->stream);
  return unify(point, NIL, exs->andb,exs);
}


int uncopiedport(prt)
     Gvainfo prt;
{
  register Term s;
  s = GvaPort(prt)->stream;
  while (IsREF(s)) {
    if (IsCopied(Ref(s))) {
      break;
    } else if (IsUnBoundRef(Ref(s))) {
      return 0;
    }
    s = RefTerm(Ref(s));
  }
  return 1;
}


bool unifyport(prt,y,andb,exs)
     Term prt;
     Term y;
     andbox *andb;
     exstate *exs;
{
  if(Eq(prt, y))
    return TRUE;
  return FALSE;
}


int killport(prt)
     port *prt;
{
  return 1;
}


int printport(file,prt,tsiz)
     FILE *file;
     port *prt;
     int tsiz;
{
  Term s;
  Deref(s, prt->stream);
  if(IsVar(s))
    fprintf(file,"{port: _%d}",variable_descriptor(s));
  else
    fprintf(file,"{port: ...}");
  return 1;
}


/* These predicate are exported to the AKL level.
 *
 *
 */


/* port/1 Port */
bool akl_port(Arg)
     Argdecl;
{
  Term X0;
  Deref(X0,A(0));
  
  if(IsPort(X0))
    return TRUE;
  IfVarSuspend(X0);
  return FALSE;
}
  

/* open_port/2 Port, List */
bool akl_open_port(Arg)
     Argdecl;
{
  Term X0, X1, res;
  port *prt;
  
  Deref(X0,A(0));		/* The term unified with the port */
  Deref(X1,A(1));		/* The stream associated ith the port */

  MakeGvainfo(prt,port,&portmethod,exs->andb);
  prt->stream = X1;

  add_gvainfo_to_close((Gvainfo)prt,exs);
  
  MakeCvaTerm(res, (Gvainfo)prt);

  return unify(X0,res,exs->andb,exs);
}


/* close_port/1 Port */
bool akl_close_port(Arg)
     Argdecl;
{
  Term X0;
  
  Deref(X0,A(0));

  if(IsPort(X0)) {
    Gvainfo g = RefGva(Ref(X0));
    DerefGvaEnv(g);
    if(IsLocalEnv(g->env,exs->andb)) {
      Term point;
      Deref(point, GvaPort(g)->stream);
      return unify(point, NIL, exs->andb,exs);
    }
    /* A constraint is constructed without a suspension.
     * The constraint will be retried when promoted.
     */
    return SUSPEND;
  }
  IfVarSuspend(X0);
  return FALSE;
}


/* send(Term, Port) */

bool akl_send_2(Arg)
     Argdecl;
{
  Term theport,message;
  
  Deref(message,A(0));		/* The message to send */
  Deref(theport,A(1));		/* The port to send to */

  if(IsCvaTerm(theport)) {
    DerefGvaEnv(RefGva(Ref(theport)));
    if(IsLocalGVA(Ref(theport),exs->andb)) {

      if(IsPort(theport)) {
	Term cons;
	Term new, point;
	
	/* Pick up the current insertion point of the stream */
	point = Port(theport)->stream;
	
	Deref(point, point);
	
	/* Construct a new cons and a new variable */
	MakeListTerm(cons);		
	InitVariable(LstCdrRef(Lst(cons)), exs->andb);
	
	/* The message to be sent */
	LstCar(Lst(cons)) = message;
	
	/* cdr is made the new insertion point */
	GetLstCdr(new, Lst(cons));
	Port(theport)->stream = new;
	
	/* unify the current insertion point with the new cons */
	return unify(point, cons, exs->andb, exs);

      } else {
	bool (*sfunc)() = RefCvaMethod(Ref(theport))->send;
	
	if(sfunc != NULL)
	  return sfunc(message, theport, exs);
	else
	  return FALSE;
      }

    } else {
      /* The port is not local to the current andbox */
      /* A constraint is constructed without a suspension.
       * The constraint will be retried when promoted.
       */
      WARNING("send/2: non-local port - suspending");
      return SUSPEND;
    }
  }
  IfVarSuspend(theport);
  return FALSE;
}

/* send(Term, InPort, OutPort) */

bool akl_send_3(Arg)
     Argdecl;
{
  Term inport,message,outport;
  
  Deref(message,A(0));		/* The message to send */
  Deref(inport, A(1));		/* The port to send to */
  Deref(outport,A(2));		/* The port after the message */

  if(IsCvaTerm(inport)) {
    DerefGvaEnv(RefGva(Ref(inport)));
    if(IsLocalGVA(Ref(inport),exs->andb)) {

      if(IsPort(inport)) {
	Term cons;
	Term new, point;
	
	/* Pick up the current insertion point of the stream */
	point = Port(inport)->stream;
	
	Deref(point, point);
	
	/* Construct a new cons and a new variable */
	MakeListTerm(cons);
	InitVariable(LstCdrRef(Lst(cons)), exs->andb);
	
	/* The message to be sent */
	LstCar(Lst(cons)) = message;
	
	/* cdr is made the new insertion point */
	GetLstCdr(new, Lst(cons));
	Port(inport)->stream = new;
	
	/* unify the current insertion point with the new cons */
	/* the third argument is unified with the port */      
	
	return (unify(point, cons, exs->andb, exs)
		&& unify(inport,outport,exs->andb,exs));

      } else {
	bool (*sfunc)() = RefCvaMethod(Ref(inport))->send;
	bool res;
	
	if(sfunc != NULL)
	  res = sfunc(message, inport, exs);
	else
	  return FALSE;
	
	if(res == TRUE)
	  return unify(inport,outport,exs->andb,exs);
	else
	  return res;
	
      }
    
    } else {
      /* The port is not local to the current andbox */
      /* A constraint is constructed without a suspension.
       * The constraint will be retried when promoted.
       */
      WARNING("send/3: non-local port - suspending");
      return SUSPEND;
    }
  }
  IfVarSuspend(inport);
  return FALSE;
}


void initialize_port() {

  define("open_port",akl_open_port,2);
  define("close_port",akl_close_port,1);
  define("send",akl_send_2,2);      
  define("send",akl_send_3,3);

  send3_def = get_predicate(store_atom("send"), 3);
}
