/* $Id: encodeinstr.h,v 1.4 1993/06/30 09:35:06 bd Exp $ */

/* These macros turn the instruction definitions into encoding macros */

/* Basic hooks: */

#define CodeWord(n,x)		PutCodeWord(n,x)
#define BeginCodeWord(n)	{ code asmword = 0
#define CodeField(x,i,n)	asmword += MakeCodeField(x,i,n)
#define EndCodeWord(n)		PutCodeWord(n,asmword); \
				}
#define StartInstruction(op)	CodeWord(0,(code)EnumToCode(op));
#define EndInstruction(n)	pc += (n)

/* Special operand types: */

#define LabelWord(n,x) \
	if ((x) >= MAXLABELS) label_overflow(); \
	CodeWord(n,labelrefs[x]); \
	labelrefs[x] = (char*)(pc+(n)) - (char*)codebase

#define IndexWord(n,x)		CodeWord(n,IndexToOffset(x))
#define IndexField(x,i) \
	CodeField(IndexToOffset(x),i*INDEX_BITS,INDEX_BITS)

#define FunctorWord(n,f)	CodeWord(n,(code)(f))
#define TermWord(n,x)		CodeWord(n,term_to_code(x))
#define PredWord(n,p)		CodeWord(n,(code)(p))

/* Auxiliary macros: */

#define MakeCodeField(x,i,n)	(((x) & ((1L << (n))-1)) << (i))
#define PutCodeWord(n,x)	*(pc+(n)) = (x)

#define ConstFunctor(name,arity)	store_functor(store_atom(name),arity)
#define ConstAtom(name)		TagAtm(store_atom(name))
#define ConstInt(number)	TagInt(swordInt(number))
#define ConstFlt(number)	TagFlt(store_float(number))
#define GetPred(name,arity)	get_predicate(store_atom(name),arity)

#define pc codecurrent
