/* $Id: config.c,v 1.14 1993/06/21 12:53:17 bd Exp $ */

#include <string.h>
#include "include.h"
#include "term.h"
#include "storage.h"
#include "error.h"


/* The function tp is meant for debugging.
 * In GDB, type "print *tp(x)" to see the parts of the tagged pointer x.
 */
static struct debug_term { tval tag; void *address; } termbuf;

struct debug_term *tp(x)
    Term x;
{
  termbuf.tag = PTagOf(x);
  termbuf.address = (void *) AddressOf(x);
#ifdef OTH
  if (termbuf.tag == OTH) {
    termbuf.tag = STagOf(x);
    termbuf.address = (void *) AddressOth(x);
  }
#endif
  return &termbuf;
}

#ifdef TADTURMS

/* This is used by a few macros (notably TagPtr) when TADTURMS is defined,
 * since a macro can't initialize and return a structure. The only purpose
 * for TADTURMS is for a little easier debugging when your terms, pointers,
 * and unsigned longs get mixed up.
 */

Turm tad_to_turm(A)
    tagged_address A;
{
  Turm temp;
  Tad(temp) = A;
  return temp;
}

#endif


Atom make_atom(str,hashval)
    char *str;
    int hashval;
{
  atom *a;
  char *s;
  register int len;

  NewAtom(a);

  len = strlen(str);
  s = qalloc(sizeof(char) * (len + 1));
  (void) strcpy(s,str);
  
  a->hashval = hashval;
  a->pname = s;
  return a;
}

Functor make_functor(name,arity)
     Atom name;
     int arity;
{
  Functor f;
  NewFunctor(f);
  f->name = name;
  f->arity = arity;
  return f;
}


Fp make_constant_float(value)
  double value;
{
  Fp i;
  NewConFlt(i);
  i->val = value;
  i->tag2 = FLT_TAG2;
  return i;
}


