%{
#include 	<stdio.h>
#include	<setjmp.h>
#include	"y.tab.h"
#define		KEYWDNO  45
#define		MAXNUMFUNC 50
#define 	PTRUE 1
#define 	PFALSE 0

%}
	int 	functor_count = 0 ;	
				/*stores number of functors*/
	char	*functor_array[MAXNUMFUNC];   
				/*stores the names of functors*/
	int	line	= 0;	/* input file line counter */
	int	i,k,n;		/*temporary*/
	char	ch1,ch2;	/*temporary*/
	short int  fakeeof;	/*global var for faking EOF*/
	short int  bracket_count;
			  /*bracket count keeps count of []() in listread*/
	short int  list_read_flag = PFALSE;
			  /*this flag is PTRUE when list is read*/
	extern int consult_ptr;
	extern short int yyprs_begin;
	extern jmp_buf parserrbuff;
	extern char *openfilename;

NUM     [0-9][0-9]*
IDS     [a-zA-Z][a-zA-Z0-9]*


%START 	IN_CMT ATOM STRING

%%
			if ((yyin == stdin) && (yyprs_begin == PTRUE)
			        && (consult_ptr == 1))
				    {
				     yyprs_begin = PFALSE;
				     return(TQMARK);
				    };
			if ((yyprs_begin == PTRUE) && (
					list_read_flag == PTRUE))
				    {
				     yyprs_begin = PFALSE;
				     return(TQMARK);
				    };
[ \t]			;
\n			{++line; 
			 if (fakeeof == 1) 
				{fakeeof = 0;
				 return(EOF);
				}
			}
"|"			{return(TBAR);}
":"			{return(TCOLON);}
"+"			{return(TPLUS);}
"-"			{return(TMINUS);}
"*"			{return(TMUL);}
"/"			{return(TDIVIDE);}
"["			{if (list_read_flag == PTRUE)
				bracket_count++;
			 return(TLBRACK);}
"]"			{if (list_read_flag == PTRUE)
			     if (--bracket_count == 0) 
			        {ungetc('\n', yyin);
			         ungetc('.', yyin);
				};
			 return(TRBRACK);}
">="			{return(TGREATEREQ);}
"<="			{return(TLESSEQ);}
"<-"			{return(TBELONG);}
"<"			{return(TLESSP);}
">"			{return(TGREATERP);}
"("			{if (list_read_flag == PTRUE)
				bracket_count++;
			 return(TLPAR);}
")"			{if (list_read_flag == PTRUE)
			    if (--bracket_count == 0) 
			        {ungetc('\n', yyin);
			         ungetc('.', yyin);
				};
			 return(TRPAR);}
","			{return(TCOMMA);}
";"			{return(TSEMCOL);}
"="			{return(TEQUAL);}
"."			{fakeeof = 1; return(TPERIOD);}
"?"			{return(TQMARK);}
"''"			{printf("illegal empty atom : ignored\n");
			 return(EOF);}
\"\"			{yylval.string = "";
			 return(TSTRING);
			}
"'"			{BEGIN ATOM;}
\"			{BEGIN STRING;}
"/*"         		{BEGIN IN_CMT;}
<IN_CMT>[^/\n]*\n	{++line;}
<IN_CMT>[^/\n]+"/"	{
                          if (yytext[yyleng-2] == '*')
				BEGIN 0;
			}
[0-9][0-9]*		{
			 /*free(yylval.string);*/
			 yylval.string = (char *) malloc(yyleng+1);
			 if (yylval.string == NULL) {
					printf("No Space left on device\n");
					exit(-1);};
			 strcpy(yylval.string,yytext);
			 return(TNUM);
			}
"=>"			{return(TDEF);}
<STRING>.*/\"		{int i;
			 BEGIN 0; 
			 i = 0;
			 while(yytext[i] != '"') i++;
			 yyless(i);
			 yylval.string = (char *) malloc(yyleng+1);	
			 if (yylval.string == NULL) {
					printf("No Space left on device\n");
					exit(-1);};
			 strcpy(yylval.string,yytext);		
			 input();	/*eat the right "*/
			 return(TSTRING);
			}
<ATOM>.*/"'"		{int i;
			 BEGIN 0; 
			 i = 0;
			 while(yytext[i] != '\'') i++;
			 if (i == 0) {printf("Illegal null atom : skipping\n"); 
				      longjmp(parserrbuff, 0);};
			 yyless(i);
			 /*free(yylval.string);*/
			 yylval.string = (char *) malloc(yyleng+1);	
			 if (yylval.string == NULL) {
					printf("No Space left on device\n");
					exit(-1);};
			 strcpy(yylval.string,yytext);		
			 input();	/*eat the right '*/
			 if (is_constructor(yytext))
				return(TFUNCTORNM);
			 else
			 	return(TNATOM);
			}
"_"[_a-zA-Z0-9]*	{
			 yylval.string = (char *) malloc(yyleng+1);
			 if (yylval.string == NULL) {
                                        printf("No Space left on Device\n");
                                        exit(-1);};
                         strcpy(yylval.string,yytext);
			 return(TID);
			}
[a-z][_a-zA-Z0-9]*	{
			 k = keywd_search();
			 if ((k == TID) || (k == TFUNCTORNM))
				{
				 yylval.string = (char *) malloc(yyleng+1);
			 	 if (yylval.string == NULL) {
					printf("No Space left on Device\n");
					exit(-1);};
				 strcpy(yylval.string,yytext); 
				};
			 return(k);}
[A-Z][_a-zA-Z0-9]*       {
			 /*free(yylval.string);*/
			 yylval.string = (char *) malloc(yyleng+1);	
			 if (yylval.string == NULL) {
					printf("No Space left on Device\n");
					exit(-1);};
			 strcpy(yylval.string,yytext);		
			 if (is_constructor(yytext))
				return(TFUNCTORNM);
			 else
			 	return(TNATOM);
			}
.			{printf("illegal character  %s",yytext);
			 if (yyin != stdin)
			      printf("  in line: %d in file: %s\n", 
						line, openfilename); 
			 return(EOF);}


%%
/*************************************************/
/**** print out statistics and symbol tables *****/
/*************************************************/


yywrap()
{ 
	return(1);
}

/*************************************************/
/****					      ****/
/****  function keyword_search: searches      ****/
/****  keywords in a keyword table   and      ****/
/****  returns its token code;   returns      ****/
/****  TID if the keyword is not  found.      ****/
/****                                         ****/
/****  parameters s: the string which is      ****/
/****                to   be    searched      ****/
/****                                         ****/
/*************************************************/

int
keywd_search()
{	int i;
	static  char  *keywd[] =
	   {  "or", "and", "not","lessp", 
	     "greaterp", "numberp", "listp", 
	     "greatereq", "lesseq", "+", "-", "*", "/",
	     "mod", "div", "abs", "eq", "null", "atom", 
	     "boolean", "var", "cputime", "timer",
	     "read", "readb", "write", "writeb",
	     "constructor", "consult", "reconsult",
	     "save", "trace",
	     "if", "else", "then", 
	     "where", "true", "false", 
	     "cons", "#car", "#cdr", "line", "char", "int", "list"
	    };
		 	/*KEYWDNO should be incremented when */
			/*a new keywd is added to the   list.*/

	for (i=0; i<KEYWDNO; ++i)
		if ( !strcmp(yytext, keywd[i]))
			return(i+257);
/* the magic figure of 257 is there because Yacc */
/* generates the integer values for the terminal */
/* symbols starting from 257 */
	if (is_constructor(yytext)) 
		return(TFUNCTORNM);
	else
		return (TID);
}

int is_constructor(name)

char *name;
{int i;
 for(i = 0; i < functor_count; i++)
	if(!strcmp(name, functor_array[i]))
		return(1);
 return(0);
}



/*************************************************/
/****  function literal_insert: inserts a     ****/
/****  string s of length s_len into  the     ****/
/****  table 'table' and increments   the     ****/
/****  count corresponding to the  table.     ****/
/*************************************************/

int
literal_insert(s, s_len, table, n)
char *s;
int  s_len;
char *table[];
int  *n;
{	int i;
	char   *calloc();
	for(i=0; i < *n; i++)
		if (!strcmp(s, table[i]))
			return(i);
	++(*n);
	table[i] = (char *) calloc(s_len, sizeof(char));
	strcpy(table[i], s);
	return(i);
}

/*the main routine is to be eliminated once the yacc routine has*/
/*been written */


