int (*arith_op[75]) ();
	/*arith_op is an array of pointers to functions  which*/
	/*return an int. The result return is the value of the*/
	/*arithmetic computation done in that routine.	      */

int
is_bound(exp, env, retval)
cellptrtype exp;
varstkptrtype env;
int *retval;
{ varstkptrtype i;
  int jj;
  if (heap_tag(exp) == GNUM)
     {  *retval = heap_numb(exp);
	return(1);
     }
  else
     if (heap_tag(exp) == GID)
	{ i = env + heap_offs(exp);
	  while(var_cell_type(i) == VARTYPE)
		i = var_cell_data_var(i);
	  if (var_cell_type(i) == INTTYPE)
	     { *retval = var_cell_data_int(i);
	       return(1);
	     };
        } 
     else if (heap_tag(exp) == GUMINUS)
	     { exp = heap_lptr(exp);
	       if (is_bound (exp, env, &jj))
		  { *retval = -jj;
		    return(1); 
		  };
	     };
  return(0);
}



int
arith_mod(env, exp, envr, expr)
register varstkptrtype env;
register cellptrtype exp;
register varstkptrtype envr;
register cellptrtype expr;

{ register varstkptrtype i;
  register int op1val, op2val;
  auto varstkptrtype saveenv = env;
  auto cellptrtype op1, op2;
  auto short int done;
  op1 = heap_lptr(exp);
  op2 = heap_rptr(exp);
  sopeqn_solved = PTRUE;
  switch (heap_tag(op1))
     {
	case GID	:
	    i = env + heap_offs(op1);
	    done = 1;
	    while (done == 1) 
	      switch (var_cell_type(i))
	        {
		   case INTTYPE	:
			op1val = var_cell_data_int(i);
			done = 0;
			break;
		   case VARTYPE	:
			/*env = var_cell_env(i);*/
			i = var_cell_data_var(i);
			break;
		   case UNBOUND	:
			 if (reinvoked == PTRUE)
			    sopeqn_solved = PFALSE;
			 else
                            { sop_lhs(sopstk_top) = exp;
                              sop_rhs(sopstk_top) = expr;
                              sop_envl(sopstk_top) = env;
                              sop_envr(sopstk_top) = envr;
			      sop_done(sopstk_top) = '0';
                              sopstk_top++;
                            };
			eqn_suspended = PTRUE;
			return(1);
			break;
		   default	:
			ffail();
			return(0);
			break;
	        };
	    break;
	case GNUM	:
	    op1val = heap_numb(op1);
	    break;
	default		:
	    ffail();
	    return(0);
	    break;
      };
		
  env = saveenv;
  switch (heap_tag(op2))
     {
	case GID	:
	    i = env + heap_offs(op2);
	    done = 1;
	    while (done == 1) 
	      switch (var_cell_type(i))
	        {
		   case INTTYPE	:
			op2val = var_cell_data_int(i);
			done = 0;
			break;
		   case VARTYPE	:
			/*env = var_cell_env(i);*/
			i = var_cell_data_var(i);
			break;
		   case UNBOUND	:
			 if (reinvoked == PTRUE)
			    sopeqn_solved = PFALSE;
			 else
                            { sop_lhs(sopstk_top) = exp;
                              sop_rhs(sopstk_top) = expr;
                              sop_envl(sopstk_top) = env;
                              sop_envr(sopstk_top) = envr;
			      sop_done(sopstk_top) = '0';
                              sopstk_top++;
                            };
			eqn_suspended = PTRUE;
			return(1);
			break;
		   default	:
			ffail();
			return(0);
			break;
	        };
	    break;
	case GNUM	:
	    op2val = heap_numb(op2);
	    break;
	default		:
	    ffail();
	    return(0);
	    break;
      };
		
  return(op1val % op2val);
}

int
arith_cputime(env, exp, envr, expr)
register varstkptrtype env;
register cellptrtype exp;
register varstkptrtype envr;
register cellptrtype expr;
{
	return((int) (CPUTime() * 1000000));
}


int
arith_abs(env, exp, envr, expr)
register varstkptrtype env;
register cellptrtype exp;
register varstkptrtype envr;
register cellptrtype expr;

{ register varstkptrtype i;
  register cellptrtype op1;
  op1 = heap_lptr(exp);
  sopeqn_solved = PTRUE;
  switch (heap_tag(op1))
     {
	case GID	:
	    i = env + heap_offs(op1);
	    while (PTRUE)
	      switch (var_cell_type(i))
	        {
		   case INTTYPE	:
			return(abs(var_cell_data_int(i)));
			break;
		   case VARTYPE	:
			/*env = var_cell_env(i);*/
			i = var_cell_data_var(i);
			break;
		   case UNBOUND	:
			 if (reinvoked == PTRUE)
			    sopeqn_solved = PFALSE;
			 else
                            { sop_lhs(sopstk_top) = exp;
                              sop_rhs(sopstk_top) = expr;
                              sop_envl(sopstk_top) = env;
                              sop_envr(sopstk_top) = envr;
			      sop_done(sopstk_top) = '0';
                              sopstk_top++;
                            };
			eqn_suspended = PTRUE;
			return(1);
			break;
		   default	:
			ffail();
			return(0);
			break;
	        };
	    break;
	case GNUM	:
	    return(abs(heap_numb(op1)));
	    break;
	default		:
	    ffail();
	    return(0);
	    break;
      };
}

int
arith_uminus(env, exp, envr, expr)
register varstkptrtype env;
register cellptrtype exp;
register varstkptrtype envr;
register cellptrtype expr;

{ register varstkptrtype i;
  register cellptrtype op1;
  int rhsval;
  op1 = heap_lptr(exp);
  sopeqn_solved = PTRUE;
  switch (heap_tag(op1))
     {
	case GID	:
	    i = env + heap_offs(op1);
	    while (PTRUE)
	      switch (var_cell_type(i))
	        {
		   case INTTYPE	:
			return(-(var_cell_data_int(i)));
			break;
		   case VARTYPE	:
			/*env = var_cell_env(i);*/
			i = var_cell_data_var(i);
			break;
		   case UNBOUND	:
		      if (is_bound(expr, envr, &rhsval))
			    {var_cell_type(i) = INTTYPE;
			     var_cell_data_int(i) = -rhsval;
                             if (i < fstk_data(mrb))
                                        trailstk[trail_top++] = i;
			    }
		      else
			 if (reinvoked == PTRUE)
			    sopeqn_solved = PFALSE;
			 else
                            { sop_lhs(sopstk_top) = exp;
                              sop_rhs(sopstk_top) = expr;
                              sop_envl(sopstk_top) = env;
                              sop_envr(sopstk_top) = envr;
			      sop_done(sopstk_top) = '0';
                              sopstk_top++;
                            };
			eqn_suspended = PTRUE;
			return(1);
			break;
		   default	:
			ffail();
			return(0);
			break;
	        };
	    break;
	case GNUM	:
	    return(-(heap_numb(op1)));
	    break;
	default		:
	    ffail();
	    return(0);
	    break;
      };
}

int
arith_div(env, exp, envr, expr)
register varstkptrtype env;
register cellptrtype exp;
register varstkptrtype envr;
register cellptrtype expr;

{ register varstkptrtype i;
  register int op1val, op2val;
  auto varstkptrtype saveenv = env;
  auto cellptrtype op1, op2;
  auto short int done;
  op1 = heap_lptr(exp);
  op2 = heap_rptr(exp);
  sopeqn_solved = PTRUE;
  switch (heap_tag(op1))
     {
	case GID	:
	    i = env + heap_offs(op1);
	    done = 1;
	    while (done == 1) 
	      switch (var_cell_type(i))
	        {
		   case INTTYPE	:
			op1val = var_cell_data_int(i);
			done = 0;
			break;
		   case VARTYPE	:
			/*env = var_cell_env(i);*/
			i = var_cell_data_var(i);
			break;
		   case UNBOUND	:
			 if (reinvoked == PTRUE)
			    sopeqn_solved = PFALSE;
			 else
                            { sop_lhs(sopstk_top) = exp;
                              sop_rhs(sopstk_top) = expr;
                              sop_envl(sopstk_top) = env;
                              sop_envr(sopstk_top) = envr;
			      sop_done(sopstk_top) = '0';
                              sopstk_top++;
                            };
			eqn_suspended = PTRUE;
			return(1);
			break;
		   default	:
			ffail();
			return(0);
			break;
	        };
	    break;
	case GNUM	:
	    op1val = heap_numb(op1);
	    break;
	default		:
	    ffail();
	    return(0);
	    break;
      };
		
  env = saveenv;
  switch (heap_tag(op2))
     {
	case GID	:
	    i = env + heap_offs(op2);
	    done = 1;
	    while (done == 1) 
	      switch (var_cell_type(i))
	        {
		   case INTTYPE	:
			op2val = var_cell_data_int(i);
			done = 0;
			break;
		   case VARTYPE	:
			/*env = var_cell_env(i);*/
			i = var_cell_data_var(i);
			break;
		   case UNBOUND	:
			 if (reinvoked == PTRUE)
			    sopeqn_solved = PFALSE;
			 else
                            { sop_lhs(sopstk_top) = exp;
                              sop_rhs(sopstk_top) = expr;
                              sop_envl(sopstk_top) = env;
                              sop_envr(sopstk_top) = envr;
			      sop_done(sopstk_top) = '0';
                              sopstk_top++;
                            };
			eqn_suspended = PTRUE;
			return(1);
			break;
		   default	:
			ffail();
			return(0);
			break;
	        };
	    break;
	case GNUM	:
	    op2val = heap_numb(op2);
	    break;
	default		:
	    ffail();
	    return(0);
	    break;
      };
		
  if (op2val != 0)
  	return(op1val / op2val);
  else 
       { printf("Attempt to divide by zero: abort\n");
	 longjmp(execbuff, 0);
       };
}

int
arith_plus(env, exp, envr, expr)
register varstkptrtype env;
register cellptrtype exp;
register varstkptrtype envr;
register cellptrtype expr;

{ register varstkptrtype i;
  int op1val, op2val, rhsval;
  auto varstkptrtype saveenv = env;
  auto cellptrtype op1, op2;
  auto short int done;
  op1 = heap_lptr(exp);
  op2 = heap_rptr(exp);
  sopeqn_solved = PTRUE;
  switch (heap_tag(op1))
     {
	case GID	:
	    i = env + heap_offs(op1);
	    done = 1;
	    while (done == 1) 
	      switch (var_cell_type(i))
	        {
		   case INTTYPE	:
			op1val = var_cell_data_int(i);
			done = 0;
			break;
		   case VARTYPE	:
			/*env = var_cell_env(i);*/
			i = var_cell_data_var(i);
			break;
		   case UNBOUND	:
			if ((is_bound(op2, saveenv, &op2val)) && 
		                           (is_bound(expr, envr, &rhsval)))
					  /*rhsval will have value of rhs*/
					  /*op2val will have value of op2*/
			    {var_cell_type(i) = INTTYPE;
			     var_cell_data_int(i) = rhsval - op2val;
			     if (i < fstk_data(mrb)) 
					trailstk[trail_top++] = i;
			    }
			else
			 if (reinvoked == PTRUE)
			    sopeqn_solved = PFALSE;
			 else
                            { sop_lhs(sopstk_top) = exp;
                              sop_rhs(sopstk_top) = expr;
                              sop_envl(sopstk_top) = env;
                              sop_envr(sopstk_top) = envr;
			      sop_done(sopstk_top) = '0';
                              sopstk_top++;
                            };
			eqn_suspended = PTRUE;
				/*eqn_suspended causes the calling routine*/
				/*to ignore the solving of right hand side*/
			return(1);
			break;
		   default	:
			ffail();
			return(0);
			break;
	        };
	    break;
	case GNUM	:
	    op1val = heap_numb(op1);
	    break;
	default		:
	    ffail();
	    return(0);
	    break;
      };
		
  env = saveenv;
  switch (heap_tag(op2))
     {
	case GID	:
	    i = env + heap_offs(op2);
	    done = 1;
	    while (done == 1) 
	      switch (var_cell_type(i))
	        {
		   case INTTYPE	:
			op2val = var_cell_data_int(i);
			done = 0;
			break;
		   case VARTYPE	:
			/*env = var_cell_env(i);*/
			i = var_cell_data_var(i);
			break;
		   case UNBOUND	:
					/*op1 is known to be bound*/
			if (is_bound(expr, envr, &rhsval))
					  /*rhsval will have value of rhs*/
			    {var_cell_type(i) = INTTYPE;
			     var_cell_data_int(i) = rhsval - op1val;
			     if (i < fstk_data(mrb)) 
					trailstk[trail_top++] = i;
			    }
                        else
			 if (reinvoked == PTRUE)
			    sopeqn_solved = PFALSE;
			 else
                            { sop_lhs(sopstk_top) = exp;
                              sop_rhs(sopstk_top) = expr;
                              sop_envl(sopstk_top) = env;
                              sop_envr(sopstk_top) = envr;
			      sop_done(sopstk_top) = '0';
                              sopstk_top++;
                            };
		        eqn_suspended = PTRUE;
		        return(1);
			break;
		   default	:
			ffail();
			return(0);
			break;
	        };
	    break;
	case GNUM	:
	    op2val = heap_numb(op2);
	    break;
	default		:
	    ffail();
	    return(0);
	    break;
      };
		
  return(op1val + op2val);
}

int
arith_minus(env, exp, envr, expr)
register varstkptrtype env;
register cellptrtype exp;
register varstkptrtype envr;
register cellptrtype expr;

{ register varstkptrtype i;
  int op1val, op2val, rhsval;
  auto varstkptrtype saveenv = env;
  auto cellptrtype op1, op2;
  auto short int done;
  op1 = heap_lptr(exp);
  op2 = heap_rptr(exp);
  sopeqn_solved = PTRUE;
  switch (heap_tag(op1))
     {
	case GID	:
	    i = env + heap_offs(op1);
	    done = 1;
	    while (done == 1) 
	      switch (var_cell_type(i))
	        {
		   case INTTYPE	:
			op1val = var_cell_data_int(i);
			done = 0;
			break;
		   case VARTYPE	:
			/*env = var_cell_env(i);*/
			i = var_cell_data_var(i);
			break;
		   case UNBOUND	:
			if ((is_bound(op2, saveenv, &op2val)) && 
		                           (is_bound(expr, envr, &rhsval)))
					  /*rhsval will have value of rhs*/
					  /*op2val will have value of op2*/
			    {var_cell_type(i) = INTTYPE;
			     var_cell_data_int(i) = rhsval + op2val;
			     if (i < fstk_data(mrb)) 
					trailstk[trail_top++] = i;
			    }
                        else
			 if (reinvoked == PTRUE)
			    sopeqn_solved = PFALSE;
			 else
                            { sop_lhs(sopstk_top) = exp;
                              sop_rhs(sopstk_top) = expr;
                              sop_envl(sopstk_top) = env;
                              sop_envr(sopstk_top) = envr;
			      sop_done(sopstk_top) = '0';
                              sopstk_top++;
                            };
			eqn_suspended = PTRUE;
			return(1);
			break;
		   default	:
			ffail();
			return(0);
			break;
	        };
	    break;
	case GNUM	:
	    op1val = heap_numb(op1);
	    break;
	default		:
	    ffail();
	    return(0);
	    break;
      };
		
  env = saveenv;
  switch (heap_tag(op2))
     {
	case GID	:
	    i = env + heap_offs(op2);
	    done = 1;
	    while (done == 1) 
	      switch (var_cell_type(i))
	        {
		   case INTTYPE	:
			op2val = var_cell_data_int(i);
			done = 0;
			break;
		   case VARTYPE	:
			/*env = var_cell_env(i);*/
			i = var_cell_data_var(i);
			break;
		   case UNBOUND	:
					/*op1 is known to be bound*/
			if (is_bound(expr, envr, &rhsval))
					  /*rhsval will have value of rhs*/
			    {var_cell_type(i) = INTTYPE;
			     var_cell_data_int(i) = op1val - rhsval;
			     if (i < fstk_data(mrb)) 
					trailstk[trail_top++] = i;
			    }
                        else
			 if (reinvoked == PTRUE)
			    sopeqn_solved = PFALSE;
			 else
                            { sop_lhs(sopstk_top) = exp;
                              sop_rhs(sopstk_top) = expr;
                              sop_envl(sopstk_top) = env;
                              sop_envr(sopstk_top) = envr;
			      sop_done(sopstk_top) = '0';
                              sopstk_top++;
                            };
			eqn_suspended = PTRUE;
			return(1);
			break;
		   default	:
			ffail();
			return(0);
			break;
	        };
	    break;
	case GNUM	:
	    op2val = heap_numb(op2);
	    break;
	default		:
	    ffail();
	    return(0);
	    break;
      };
		
  return(op1val - op2val);
}

int
arith_divide(env, exp, envr, expr)
register varstkptrtype env;
register cellptrtype exp;
register varstkptrtype envr;
register cellptrtype expr;

{ register varstkptrtype i;
  int op1val, op2val, rhsval;
  auto varstkptrtype saveenv = env;
  auto cellptrtype op1, op2;
  auto short int done;
  op1 = heap_lptr(exp);
  op2 = heap_rptr(exp);
  sopeqn_solved = PTRUE;
  switch (heap_tag(op1))
     {
	case GID	:
	    i = env + heap_offs(op1);
	    done = 1;
	    while (done == 1) 
	      switch (var_cell_type(i))
	        {
		   case INTTYPE	:
			op1val = var_cell_data_int(i);
			done = 0;
			break;
		   case VARTYPE	:
			/*env = var_cell_env(i);*/
			i = var_cell_data_var(i);
			break;
		   case UNBOUND	:
			if ((is_bound(op2, saveenv, &op2val)) && 
		                           (is_bound(expr, envr, &rhsval)))
					  /*rhsval will have value of rhs*/
					  /*op2val will have value of op2*/
			    {var_cell_type(i) = INTTYPE;
			     var_cell_data_int(i) = rhsval * op2val;
			     if (i < fstk_data(mrb)) 
					trailstk[trail_top++] = i;
			    }
                        else
			 if (reinvoked == PTRUE)
			    sopeqn_solved = PFALSE;
			 else
                            { sop_lhs(sopstk_top) = exp;
                              sop_rhs(sopstk_top) = expr;
                              sop_envl(sopstk_top) = env;
                              sop_envr(sopstk_top) = envr;
			      sop_done(sopstk_top) = '0';
                              sopstk_top++;
                            };
			eqn_suspended = PTRUE;
			return(1);
			break;
		   default	:
			ffail();
			return(0);
			break;
	        };
	    break;
	case GNUM	:
	    op1val = heap_numb(op1);
	    break;
	default		:
	    ffail();
	    return(0);
	    break;
      };
		
  env = saveenv;
  switch (heap_tag(op2))
     {
	case GID	:
	    i = env + heap_offs(op2);
	    done = 1;
	    while (done == 1) 
	      switch (var_cell_type(i))
	        {
		   case INTTYPE	:
			op2val = var_cell_data_int(i);
			done = 0;
			break;
		   case VARTYPE	:
			/*env = var_cell_env(i);*/
			i = var_cell_data_var(i);
			break;
		   case UNBOUND	:
					/*op1 is known to be bound*/
			if (is_bound(expr, envr, &rhsval))
					  /*rhsval will have value of rhs*/
			    {
			     if (rhsval != 0) 
			       {
			     	var_cell_type(i) = INTTYPE;
			     	var_cell_data_int(i) = op1val / rhsval;
			     	if (i < fstk_data(mrb)) 
					trailstk[trail_top++] = i;
			       }
			     else
				if (op1val != 0)  
				    {printf("indeterminate denominator in");
				     printf(" divide: abort\n");
				     longjmp(execbuff, 0);
				    };
			    }
                        else
			 if (reinvoked == PTRUE)
			    sopeqn_solved = PFALSE;
			 else
                            { sop_lhs(sopstk_top) = exp;
                              sop_rhs(sopstk_top) = expr;
                              sop_envl(sopstk_top) = env;
                              sop_envr(sopstk_top) = envr;
			      sop_done(sopstk_top) = '0';
                              sopstk_top++;
                            };
			eqn_suspended = PTRUE;
			return(1);
			break;
		   default	:
			ffail();
			return(0);
			break;
	        };
	    break;
	case GNUM	:
	    op2val = heap_numb(op2);
	    break;
	default		:
	    ffail();
	    return(0);
	    break;
      };
		
  if (op2val != 0)
  	return(op1val / op2val);
  else 
       { printf("Attempt to divide by zero: abort\n");
	 longjmp(execbuff, 0);
       };
}

int
arith_mul(env, exp, envr, expr)
register varstkptrtype env;
register cellptrtype exp;
register varstkptrtype envr;
register cellptrtype expr;

{ register varstkptrtype i;
  int op1val, op2val, rhsval;
  auto varstkptrtype saveenv = env;
  auto cellptrtype op1, op2;
  auto short int done;
  op1 = heap_lptr(exp);
  op2 = heap_rptr(exp);
  sopeqn_solved = PTRUE;
  switch (heap_tag(op1))
     {
	case GID	:
	    i = env + heap_offs(op1);
	    done = 1;
	    while (done == 1) 
	      switch (var_cell_type(i))
	        {
		   case INTTYPE	:
			op1val = var_cell_data_int(i);
			done = 0;
			break;
		   case VARTYPE	:
			/*env = var_cell_env(i);*/
			i = var_cell_data_var(i);
			break;
		   case UNBOUND	:
			if ((is_bound(op2, saveenv, &op2val)) && 
		                           (is_bound(expr, envr, &rhsval)))
					  /*rhsval will have value of rhs*/
					  /*op2val will have value of op2*/
			    {if (op2val != 0)
				{
				 var_cell_type(i) = INTTYPE;
			     	 var_cell_data_int(i) = rhsval / op2val;
			     	 if (i < fstk_data(mrb)) 
					trailstk[trail_top++] = i;
			    	 }
			     else if (rhsval == 0) ;
				  else return(0);
			    }
                        else
			 if (reinvoked == PTRUE)
			    sopeqn_solved = PFALSE;
			 else
                            { sop_lhs(sopstk_top) = exp;
                              sop_rhs(sopstk_top) = expr;
                              sop_envl(sopstk_top) = env;
                              sop_envr(sopstk_top) = envr;
			      sop_done(sopstk_top) = '0';
                              sopstk_top++;
                            };
			eqn_suspended = PTRUE;
			return(1);
			break;
		   default	:
			ffail();
			return(0);
			break;
	        };
	    break;
	case GNUM	:
	    op1val = heap_numb(op1);
	    break;
	default		:
	    ffail();
	    return(0);
	    break;
      };
		
  env = saveenv;
  switch (heap_tag(op2))
     {
	case GID	:
	    i = env + heap_offs(op2);
	    done = 1;
	    while (done == 1) 
	      switch (var_cell_type(i))
	        {
		   case INTTYPE	:
			op2val = var_cell_data_int(i);
			done = 0;
			break;
		   case VARTYPE	:
			/*env = var_cell_env(i);*/
			i = var_cell_data_var(i);
			break;
		   case UNBOUND	:
					/*op1 is known to be bound*/
			if (is_bound(expr, envr, &rhsval))
					  /*rhsval will have value of rhs*/
			    {if (op1val != 0)
				{
				 var_cell_type(i) = INTTYPE;
			     	 var_cell_data_int(i) = rhsval / op1val;
			     	 if (i < fstk_data(mrb)) 
					trailstk[trail_top++] = i;
			    	 }
			     else if (rhsval == 0) ;
				  else return(0);
			    }
                        else
			 if (reinvoked == PTRUE)
			    sopeqn_solved = PFALSE;
			 else
                            { sop_lhs(sopstk_top) = exp;
                              sop_rhs(sopstk_top) = expr;
                              sop_envl(sopstk_top) = env;
                              sop_envr(sopstk_top) = envr;
			      sop_done(sopstk_top) = '0';
                              sopstk_top++;
                            };
			eqn_suspended = PTRUE;
			return(1);
			break;
		   default	:
			ffail();
			return(0);
			break;
	        };
	    break;
	case GNUM	:
	    op2val = heap_numb(op2);
	    break;
	default		:
	    ffail();
	    return(0);
	    break;
      };
		
  return(op1val * op2val);
}

assign_arith()
{
	arith_op[GMOD] 	   = arith_mod;
	arith_op[GDIV] 	   = arith_div;
	arith_op[GPLUS]    = arith_plus;
	arith_op[GMINUS]   = arith_minus;
	arith_op[GDIVIDE]  = arith_divide;
	arith_op[GMUL]	   = arith_mul;
	arith_op[GABS]	   = arith_abs;
	arith_op[GUMINUS]  = arith_uminus;
	arith_op[GCPUTIME] = arith_cputime;
}

