SPEC ATAXX =

MINMAX ACTUAL SORTS
                situation = situation.
                move = move.
                moves = moves.
              OPNS
                all_moves = all_moves.
                make_move = make_move.
                value = value.
                no_move = no_move.
       END+

LISTOPS +
INTEGER_UTIL +
MAP +

SORTS pos ::= p(integer,integer).
      poss ::= [pos].
      
      move ::= m pos pos.
      moves ::= [move].
      
      stone ::= white | black | none | obstacle.
      stones ::= [stone].
      
      situation ::= s(whites_move::boolean,
                     x::integer,
                     y::integer,
                     stones::stones
                    ).

OPNS no_pos:: pos.
EQNS no_pos = p(-1,-1).

OPNS no_move:: move.
EQNS no_move = m no_pos no_pos.
     
OPNS to_idx:: situation -> pos -> integer.
EQNS to_idx S (p(X,Y)) = Y*x S+X.

OPNS to_pos:: situation -> integer -> pos.
EQNS to_pos S I = p(I _mod x S,I _div x S).

OPNS value::situation -> integer.
EQNS value S = count_stones(if whites_move S then 1 else -1,stones S).

OPNS count_stones:: (integer,stones) -> integer.
EQNS count_stones(_,[]) = 0.
     count_stones(I,[white|S]) = count_stones(I,S)+I.
     count_stones(I,[black|S]) = count_stones(I,S)-I.
    $count_stones(I,[_|S]) = count_stones(I,S).

OPNS valid_pos:: situation -> pos -> boolean.
EQNS valid_pos S (p(X,Y)) = (X<x S) && (Y<y S) && (X>=0) && (Y>=0).

OPNS get_stone:: situation -> pos -> stone.
EQNS get_stone S P  =
       if valid_pos S P 
       then get_stone(stones S)(to_idx S P)
       else obstacle. 

OPNS get_stone:: stones -> integer -> stone.
EQNS get_stone [] _  = obstacle.
     get_stone [S|SS] I = if I == 0 then S else get_stone SS (I-1).
     
OPNS put_stone:: situation -> pos -> stone -> situation.
EQNS put_stone S P ST =
       if valid_pos S P 
       then stones(S,put_stone(stones S)(to_idx S P) ST)
       else S.

OPNS put_stone:: stones -> integer -> stone -> stones.
EQNS put_stone [] _ _ = [].
     put_stone [S|SS] I ST = if I==0 then [ST|SS] 
                                     else [S|put_stone SS (I-1) ST].

OPNS frees:: situation -> pos -> poss.
EQNS frees S P  = frees(get_stone S)(neib(P,-2,-2)).

OPNS frees:: (pos -> stone) -> poss -> poss.
EQNS frees _ [] = [].
     frees S [P|PP] = if S P ==none then [P|frees S PP]
                                    else frees S PP.

OPNS neib:: (pos,integer,integer) -> poss.
MACROS #dp = p(X+DX,Y+DY).
EQNS neib(p(X,Y),DX,DY) = if DX==2
                          then if DY==2
                               then [#dp]
                               else [#dp|neib(p(X,Y),DX,DY+1)]
                          else if DY==2
                               then [#dp|neib(p(X,Y),DX+1,-2)]
                               else [#dp|neib(p(X,Y),DX,DY+1)].

OPNS all_owns:: situation -> poss.
EQNS all_owns S = all_owns S 0 (whites_move S) (stones S).

OPNS all_owns:: situation -> integer -> boolean -> stones -> poss.
EQNS all_owns _ _ _ [] = [].
     all_owns SIT I WHITES [S|SS] = 
       if ((S==white) && WHITES) ||
          ((S==black) && not WHITES)
       then [to_pos SIT I|all_owns SIT (I+1) WHITES SS]
       else               all_owns SIT (I+1) WHITES SS.

OPNS all_moves:: situation -> moves.
EQNS all_moves S = connect S (all_owns S).

OPNS correct:: situation -> move -> boolean.
EQNS correct S = member (all_moves S).

OPNS eog:: situation -> boolean.
EQNS eog S = all_moves S == [].

OPNS connect:: situation -> poss -> moves.
EQNS connect _ [] = [].
     connect S [P|PP] = map (m P) (frees S P) ++ connect S PP.
     
OPNS change_player:: situation -> situation.
EQNS change_player S =  whites_move(S,not(whites_move S)).

OPNS fillup:: situation -> situation.
EQNS fillup S = 
      if eog S
      then stones(S,map (fill (if whites_move S then black else white)) 
                        (stones S))
                else S.
                 
OPNS fill :: stone -> stone -> stone.
EQNS fill ST S = if S==none then ST else S.

OPNS score:: situation -> (integer,integer).
EQNS score S = calc_score(stones S)(0,0).

OPNS calc_score:: stones -> (integer,integer) -> (integer,integer).
EQNS calc_score [] (W,B) = (W,B).
     calc_score [S|SS] (W,B) = if S==white then calc_score SS (W+1,B  )
                            elsif S==black then calc_score SS (W,  B+1)
                            else                calc_score SS (W,  B  ).

OPNS make_move:: situation -> move -> situation.
EQNS make_move S (m F T) =
       if whites_move S
       then colour(whites_move(put_stone(put_stone S T white)
                                 F (born white (m F T)),false))
                  T white (-1)(-1)
       else colour(whites_move(put_stone(put_stone S T black)
                                 F (born black (m F T)),true))
                  T black (-1)(-1).

OPNS colour:: situation -> pos -> stone -> integer -> integer -> situation.
EQNS colour S (p(X,Y)) ST DX DY = 
        if (DX==0) && (DY==0)
        then colour S (p(X,Y)) ST 1 DY
        elsif DX==2
           then colour S (p(X,Y)) ST (-1) (DY+1)
        elsif DY==2
           then S
           else colour(colour S (p(X+DX,Y+DY)) ST) (p(X,Y)) ST (DX+1) DY.

OPNS colour:: situation -> pos -> stone -> situation.
EQNS colour S P black =
       if get_stone S P == white
       then put_stone S P black
       else S.
     colour S P white =
       if get_stone S P == black
       then put_stone S P white
       else S.
    $colour S _ _ = S.

OPNS born:: stone -> move -> stone.
EQNS born S  (m (p(X1,Y1)) (p(X2,Y2))) =
       if (abs(X1-X2) <= 1) && (abs(Y1-Y2) <= 1)
       then S
       else none.

OPNS init_sit:: situation.
EQNS init_sit = s(true,7,7,[none,none,none,none,none,none,none,
                            none,none,none,none,none,none,none,
                            none,none,none,none,none,none,none,
                            none,none,none,none,none,none,none,
                            none,none,none,none,none,none,none,
                            none,none,none,none,none,none,none,
                            none,none,none,none,none,none,none]).

OPNS EXTERN run:: situation -> system -> system.

OPNS goal:: system -> system.
EQNS goal S = run init_sit S.

END.
