SPEC TIME =

 BOOLEAN +
 INTEGER +
 STRING +
 
SORTS 
  time_area ::= local | gm.

  time_date ::= td(time,date).
  
  time ::= time(hour   :: integer,
                minute :: integer,
                second :: integer).
                
  date ::= date(year   :: integer,
                month  :: integer,
                day    :: integer).
  
  
OPNS 
  no_time_date :: time_date.
  
  time <  time :: boolean.
  time <= time :: boolean.
  time >  time :: boolean.
  time >= time :: boolean.
  
  date <  date :: boolean.
  date <= date :: boolean.
  date >  date :: boolean.
  date >= date :: boolean.
  
  time_date <  time_date :: boolean.
  time_date <= time_date :: boolean.
  time_date >  time_date :: boolean.
  time_date >= time_date :: boolean.
  
  filedate :: system -> time_area -> string -> (boolean,system,time_date).

LOCAL
EQNS
  no_time_date = td(time(0,0,0),date(0,0,0)).
FORALL T1,T2 :: time.
EQNS
  T1 <  T2 = not (T1>=T2).
  T1 <= T2 = not (T1> T2).
  T1 >= T2 = (T1>T2) || (T1==T2).
  
  time(H1,M1,S1) > time(H2,M2,S2) =
    if H1 < H2
    then false
    elsif H1 > H2
    then true
    elsif M1 < M2
    then false
    elsif M1 > M2
    then true
    else S1 > S2.

FORALL T1,T2 :: date.
EQNS
  T1 <  T2 = not (T1>=T2).
  T1 <= T2 = not (T1> T2).
  T1 >= T2 = (T1>T2) || (T1==T2).
  
  date(Y1,M1,D1) > date(Y2,M2,D2) =
    if Y1 < Y2
    then false
    elsif Y1 > Y2
    then true
    elsif M1 < M2
    then false
    elsif M1 > M2
    then true
    else D1 > D2.

FORALL T1,T2 :: time_date.
EQNS
  T1 <  T2 = not (T1>=T2).
  T1 <= T2 = not (T1> T2).
  T1 >= T2 = (T1>T2) || (T1==T2).
  
  td(TIME1,DATE1) > td(TIME2,DATE2) =
    if DATE1 < DATE2 then false
    elsif DATE1==DATE2 then TIME1>TIME2
       else true.

MACROS
  (#lok,#lye,#lmo,#lda,#lh,#lmi,#lse,#lsy) = fdate (FName,true, Sys).
  (#gok,#gye,#gmo,#gda,#gh,#gmi,#gse,#gsy) = fdate (FName,false,Sys).
  
EQNS
  filedate Sys local FName = (#lok,#lsy,td(time(#lh,#lmi,#lse),date(#lye,#lmo,#lda))).
  filedate Sys gm    FName = (#gok,#gsy,td(time(#gh,#gmi,#gse),date(#gye,#gmo,#gda))).

OPNS  
 EXTERN fdate :: (string,boolean,system)
        -> (boolean,
            integer,integer,integer,integer,integer,integer,
            system).
END.
