SPEC LISTOPS =

FORMAL SORTS data. list ::= [data].

GLOBAL

  INTEGER +
  
OPNS 

{ the miranda set of listops }

  length :: list -> integer.
  
  list ! integer :: data.
  
  list ++ list :: list.
  list -- list :: list.

  hd :: list -> data.
  tl :: list -> list.

  init :: list -> list.
  last :: list -> data.

  drop :: integer -> list -> list.
  dropwhile :: (data -> boolean) -> list -> list.

  take :: integer -> list -> list.
  takewhile :: (data -> boolean) -> list -> list.

  mkset :: list -> list.
  
  reverse :: list -> list.
  
  postfix :: data -> list -> list.
  
  rep :: integer -> data -> list.
  
  member :: list -> data -> boolean.

  limit :: list -> data.
  
  select :: (data -> data -> boolean) -> list -> data.
  
  merge :: (data -> data -> boolean) -> list -> list -> list.
  
{ more listops }

  insert :: data -> list -> list.
  union :: list -> list -> list.
  intersect :: list -> list -> list.
  subset :: list -> list -> boolean.
  
  insert_behind_ith :: (integer,data,list) -> list.
  delete_ith :: (integer,list) -> list.
  
  idx :: list -> data -> integer.
  
  is_head_of :: (list,list) -> boolean.
  replace_head_by :: (list,list) -> list.
  
  single :: list -> boolean.
  
  ismt :: list -> boolean.
  
  split :: integer -> list -> (list,list).
  
  list | data :: list.
  
LOCAL
  ERROR +

EQNS
  length [] = 0.
  length (_:X) = 1+length X.
  
  []    ! _ = error "subscript out of range".
  (A:X) ! N = if N==0 then A
                      else X ! (N-1).
  
  []    ++ Y = Y.
  (A:X) ++ Y = A:(X++Y).
  
  X -- []    = X.
  X -- (B:Y) = (remove B X) -- Y.

OPNS remove :: data -> list -> list.
EQNS remove _ [] = [].
     remove B (A:X) = if B==A then X 
                              else A:remove B X.

  hd (A:_) = A.
  hd [] = error "hd []".

  tl (_:X) = X.
  tl [] = error "tl []".

  init [] = error "init []".
  init (A:X) = if X==[] then [] 
                        else A:init X.

  last [] = error "last []".
  last (A:X) = if X==[] then A
                        else last X.
  
  drop _ [] = [].
  drop N (A:X) = if N>0 then drop (N-1) X 
                        else A:X.

  dropwhile _ [] = [].
  dropwhile F (A:X) = if F A then dropwhile F X 
                             else A:X.

  take _ [] = [].
  take N (A:X) = if N>0 then A:take (N-1) X
                        else [].

  takewhile _ [] = [].
  takewhile F (A:X) = if F A then A:takewhile F X
                             else [].

  mkset [] = [].
  mkset (A:X) = if member X A then mkset(A:remove A X) 
                              else A:mkset X.
  
  reverse = reverse_ [].
  
OPNS reverse_ :: list -> list -> list.
EQNS reverse_ Y [] = Y.
     reverse_ Y (A:X) = reverse_ (A:Y) X.

  postfix A X = X ++ [A].
  
  rep N D = if N <= 0 then [] 
                      else D:rep(N-1) D.
  
  member [] _ = false.
  member (A:X) B = if A==B then true else member X B.
  
  limit (A:(B:X)) = if A==B then A
                            else limit (B:X).
 $limit _ = error "incorrect use of limit".
 
  select _ [] = error "incorrect use of select".
  select _ [A] = A.
  select F (A:(B:X)) = select F ((if F A B then A else B):X).
  
  merge _ []    []    = [].
  merge _ []    (B:Y) = B:Y.
  merge _ (A:X) []    = A:X.
  merge F (A:X) (B:Y) = if F A B then A:merge F X (B:Y)
                                 else B:merge F (A:X) Y.
                                 
   
EQNS
  insert A X = if member X A then X else A:X.
  
  union [] Y = Y.
  union (A:X) Y = if member Y A then   union X Y 
                                else A:union X Y.
  
  intersect [] _ = [].
  intersect (A:X) Y = if member Y A then A:intersect X Y 
                                    else   intersect X Y.

  subset [] _ = true.
  subset (A:X) Y = member Y A && subset X Y.
 
  insert_behind_ith(N,D,[]) = 
       if N==0 then [D] 
               else error "wrong index in insert_behind_ith".
  insert_behind_ith(N,D,A:X) = 
       if N<0 then error "wrong index in insert_behind_ith" 
              elsif N==0 then D:(A:X)
                         else A:insert_behind_ith(N-1,D,X).

  delete_ith(_,[]) = [].
  delete_ith(N,A:X) = if N<1 then error "wrong index in delete_ith" else 
                      if N==1 then X else A:delete_ith(N-1,X).
                        
  idx []    _ = -1.
  idx (A:X) D = if A==D        then  0 
             elsif idx X D < 0 then -1 
             else                    1+idx X D.

  is_head_of(_:_,[]) = false.
  is_head_of([],_) = true.
  is_head_of(A:X,B:Y) = (A==B) && is_head_of(X,Y).
  
  replace_head_by(_:_,[]) = [].
  replace_head_by([],Y) = Y.
  replace_head_by(A:X,_:Y) = A:replace_head_by(X,Y).

  single [_] = true.
 $single _ = false.
 
  ismt = (==) [].
  
MACROS 
  (#l,#r) = split(N-1) X.

EQNS
  split N (A:X) = if N==0 then ([],A:X) else (A:#l,#r).
  split _ [] = ([],[]).
 
  X|A = A:X.
  
END.
