SPEC INTEGER_UTIL =
  
  BOOLEAN +
  INTEGER +
  CHAR +
  STRING +
  
OPNS
  integer_string  :: integer -> string.
  max, min        :: (integer,integer) -> integer.
  sqr, abs, sgn   :: integer -> integer. 
  convert_to_base :: (integer,integer) -> integer.

LOCAL  

OPNS
  integer_string1 :: (integer,string) -> string.
  
EQNS
  integer_string I =
    if I < 0
    then '-':integer_string1(negate I,"")
    else integer_string1(I,"").

MACROS 
  #N=char_integer '0'.
  
EQNS
  integer_string1(I,S) =
    if I _div 10 == 0
    then integer_char(I+#N):S
    else integer_string1(I _div 10,integer_char((I _mod 10)+ #N):S).

EQNS
  sqr X = X*X.
  sgn X = if X < 0 then -1 elsif X > 0 then 1 else 0.
  abs X = if X < 0 then negate X else X.
  min(X,Y) = if X < Y then X else Y.
  max(X,Y) = if X < Y then Y else X.

EQNS
  convert_to_base(TO,X) = 
    if X == 0
    then 0
    else (X _mod TO) + (10*(convert_to_base(TO,(X _div TO)))).

END.
