SPEC INOUT =

FORMAL SORTS data.

GLOBAL 
  
  SYSTEM +
  
OPNS 
  in  :: (string,data,integer,system) -> (boolean,data,system).
  out :: (string,data,integer,system) -> (boolean,system).

MACROS
  (#ok1,#sys1)       = openread(FileHandle,FileName) SYS.
  (#ok2,#sys2)       = readdevice FileHandle #sys1.
  (#ok3,#data,#sys3) = read(ErrData,#sys2).
  (#ok4,#sys4)       = closefile FileHandle #sys3.

  (_,#sys2_e) = closefile FileHandle #sys2.
  (_,#sys3_e) = closefile FileHandle #sys3.
  
EQNS
  in(FileName,ErrData,FileHandle,SYS) = 
    if #ok1
    then if #ok2
         then if #ok3
              then (#ok4,#data,#sys4)
              else (#ok3,ErrData,#sys3_e)
         else (#ok2,ErrData,#sys2_e)
    else (#ok1,ErrData,#sys1).
    
MACROS
  (#ok1,#sys1) = openwrite(FileHandle,FileName) SYS.
  (#ok2,#sys2) = writedevice FileHandle #sys1.
  (#ok3,#sys3) = write(Data,#sys2).
  (#ok4,#sys4) = closefile FileHandle #sys3.

  (_,#sys2_e) = closefile FileHandle #sys2.
  (_,#sys3_e) = closefile FileHandle #sys3.
  
EQNS
  out(FileName,Data,FileHandle,SYS) =
    if #ok1
    then if #ok2
         then if #ok3
              then (#ok4,#sys4)
              else (#ok3,#sys3_e)
         else (#ok2,#sys2_e)
    else (#ok1,#sys1).

END.
