SPEC ILIST =

FORMAL 
  
  SORTS index. indices ::= [index].
        data.  datas ::= [data].

GLOBAL
 
  SORTS list ::= ilist(indices::indices,datas::datas).

  OPNS mt ::  list.
       ismt :: list -> boolean.
       
       (index,data) : list :: list.
       
       insert :: (index,data) -> list -> list.
       
       extend :: (index,data) -> (data->data->data) -> list -> list.
       
       del :: index -> list -> list.
       
       get :: (index,data) -> list -> (boolean,data).
       
       member :: list -> index -> boolean.
       
       hd :: list -> (index,data).
       tl :: list -> list.
       
LOCAL
  LISTOPS ACTUAL SORTS data=index. list=indices. END+ 
  LISTOPS ACTUAL SORTS data=data.  list=datas.   END+ 
  TWO +

EQNS
  mt = ilist([],[]).
  
  ismt(ilist([],[])) = true.
 $ismt(ilist _) = false.
 
  (I,D) : (ilist(Is,Ds)) = ilist(I:Is,D:Ds).

  insert ID LIST = extend ID const LIST.

  extend ID JOIN (ilist IsDs) = ilist(extend ID JOIN IsDs).

  del IDX (ilist IsDs) = ilist(del IDX IsDs).

  get ID (ilist IsDs) = get ID IsDs.
  
  member (ilist(Is,_)) = member Is.
  
  hd(ilist(Is,Ds)) = (hd Is,hd Ds).
  
  tl(ilist(Is,Ds)) = ilist(tl Is,tl Ds).

OPNS
  extend :: (index,data) -> (data->data->data) -> 
            (indices,datas) -> (indices,datas).

MACROS 
  (#Is,#Ds) = extend (I,D) JOIN (Is,Ds).

EQNS  
 $extend (I,D) _ _ = ([I],[D]).
  extend (I,D) JOIN (I1:Is,D1:Ds) = if I==I1 then (I1:Is,JOIN D D1:Ds)
                                             else (I1:#Is,D1:#Ds).


OPNS
  del :: index -> (indices,datas) -> (indices,datas).
  
MACROS
  (#Is,#Ds) = del IDX (Is,Ds).
  
{FORALL del :: index -> (indices,datas) -> (indices,datas).}
EQNS
 $del _ (IsDs::(indices,datas)) = IsDs.
  del IDX ((I:Is,D:Ds)::(indices,datas)) = if IDX==I then (Is,Ds) 
                                  else (I:#Is,D:#Ds).


OPNS  
  get :: (index,data) -> (indices,datas) -> (boolean,data).

FORALL get ::  (index,data) -> (indices,datas) -> (boolean,data). 
EQNS 
 $get (_,ERR) _ = (false,ERR).
  get (IDX,ERR) (I:Is,D:Ds) = if I==IDX then (true,D)
                                        else get (IDX,ERR) (Is,Ds).

END.
