/*-------------------------------------------------------------------------*/
/* Benchmark (Finite Domain)            INRIA Rocquencourt - ChLoE Project */
/*                                                                         */
/* Name           : send.pl                                                */
/* Title          : crypt-arithmetic                                       */
/* Original Source: P. Van Hentenryck's book                               */
/* Adapted by     : Daniel Diaz - INRIA France                             */
/* Date           : September 1992                                         */
/*                                                                         */
/* Solve the operation:                                                    */
/*                                                                         */
/*      S E N D                                                            */
/*  +   M O R E                                                            */
/*  -----------                                                            */
/*  = M O N E Y                                                            */
/*                                                                         */
/* (resolution by line)                                                    */
/*                                                                         */
/* Solution:                                                               */
/*  [S,E,N,D,M,O,R,Y]                                                      */
/*  [9,5,6,7,1,0,8,2]                                                      */
/*-------------------------------------------------------------------------*/

:- main.

q:-	get_labeling(Lab), statistics(runtime,_),
	send(LD,Lab), statistics(runtime,[_,Y]),
	write(LD), nl,
	write('time : '), write(Y), nl,
	halt(0).




send(LD,Lab):-
	LD=[S,E,N,D,M,O,R,Y],
	alldifferent(LD),
	domain(LD,0,9),
	S in 1..9,
	M in 1..9,

	   1000*S+100*E+10*N+D + 1000*M+100*O+10*R+E 
	#= 10000*M+1000*O+100*N+10*E+Y,

	lab(Lab,LD).




lab(normal,L):-  
	labeling(L).

lab(ff,L):-
	labelingff(L).




get_labeling(Lab):- 
	argc(C),
	get_labeling1(C,Lab).


get_labeling1(1,normal).

get_labeling1(2,Lab):-
	argv(1,Lab).




:- q.
