/*-------------------------------------------------------------------------*/
/* Lecture du fichier source                                               */
/*                                                                         */
/* predicat d'appel:                                                       */
/*   lire_fichier(FicIn,LSrc,Main,LPPublic).                               */
/*                                                                         */
/* entree                                                                  */
/* FicIn     : nom du programme prolog a compiler                          */
/*                                                                         */
/* sortie                                                                  */
/* LSrc      : liste des clauses du programme                              */
/* Main      : no_main ou declaration de main                              */
/* LPPublic  : liste des predicats declares publics (:- public ...)        */
/*             LPPublic = [P/N, ...]                                       */
/*                                                                         */
/* traitement des directives:                                              */
/*                                                                         */
/* Les directives :- public ... permettent de constituer la liste LPPublic */
/* a pres quoi on ne garde aucune trace de ces directives dans LSrc.       */
/*                                                                         */
/* On verifie si dans une directive il y a une declaration d'operateur     */
/* (op/3), si c'est le cas elle est executee.                              */
/*                                                                         */
/* Toutes les directives autres que :- public sont transformees en:        */
/*                                                                         */
/* :- Corps1. devient '$exec_1':- Corps1, !.                               */
/* :- Corps2. devient '$exec_2':- Corps2, !.                               */
/*       :                                                                 */
/* :- Corpsk. devient '$exec_k':- Corpsk, !.                               */
/*                                                                         */
/* Chaque directive est transformee en clause dont la tete est unique car  */
/* on utilise un numero sequentiel. Au moment de l'emission du code les    */
/* clause '$exec_i' seront distinguees.                                    */
/* L'ajout du ! en fin provient du fait qu'il n'y a pas de backtracking    */
/* sur les directives.                                                     */
/*-------------------------------------------------------------------------*/

:- public lire_fichier/3.

lire_fichier(LSrc,Main,LPPublic):-
	g_read(fic_in,FicIn),
	g_assign(nb_pred_exec,0),
	see(FicIn),
	read_term(ClSrc,[singletons(SingNames),syntax_errors(fail)]),
	lire_clauses(ClSrc,SingNames,LSrc,Main,LPPublic),
	!,
	seen.




lire_clauses(end_of_file,_,LSrc,Main,[]):-
	!,                                            % cut important
	(var(Main) -> Main=no_main,
		      LSrc=[]
                   ;  
		      make_directive(top_level,Directive),
		      LSrc=[Directive]).

lire_clauses((:- public P),_,LSrc,Main,LPPublic1):-
	!,                                            % cut important
	read_term(ClSrc1,[singletons(SingNames1),syntax_errors(fail)]),
	lire_clauses(ClSrc1,SingNames1,LSrc,Main,LPPublic),
	ajout_pred_public(P,LPPublic,LPPublic1).

lire_clauses((:- C),_,LSrc,Main,LPPublic):-
	!,                                            % cut important
	(functor(C,main,_) 
                   -> Main=C,
		      LSrc=LSrc1
		   ;
		      make_directive(C,Directive),
		      LSrc=[Directive|LSrc1]),
	read_term(ClSrc1,[singletons(SingNames1),syntax_errors(fail)]),
	lire_clauses(ClSrc1,SingNames1,LSrc1,Main,LPPublic).

lire_clauses(ClSrc,SingNames,[ClSrc|LSrc],Main,LPPublic):-
	(ClSrc=(H:-_) ; ClSrc=H),
	functor(H,F,N),
	!,
	pred_name_to_gvar_name(F,N,GVar),
	g_read(module,Module),
	g_assign(GVar,Module),
	get_singletons(SingNames,Sing),
	(Sing\==[] 
            -> formata('{Warning: ~w - singleton variables in ~a/~d}~n',
                       [Sing,F,N])
            ;  true),
	read_term(ClSrc1,[singletons(SingNames1),syntax_errors(fail)]),
	lire_clauses(ClSrc1,SingNames1,LSrc,Main,LPPublic).




make_directive(C,(PredExec:-C,!)):-
	traite_op(C),
	g_read(nb_pred_exec,Exe),
	Exe1 is Exe+1,
	g_assign(nb_pred_exec,Exe1),
	create_exec_name(Exe1,PredExec).




traite_op((P,Q)):-                                % on ne traite pas (P;Q).
	traite_op(P),
	traite_op(Q).
	                           
traite_op(op(X,Y,Z)):-                            % on execute op/3
	op(X,Y,Z).

traite_op(_).




get_singletons([],[]).

get_singletons([X=_|SingNames],Sing1):-
	(sub_atom(X,1,1,'_') -> Sing1=Sing
                             ;  Sing1=[X|Sing]),
	get_singletons(SingNames,Sing).




ajout_pred_public((P1,P2),LPPublic,LPPublic2):-
	ajout_pred_public(P1,LPPublic,LPPublic1),
	ajout_pred_public(P2,LPPublic1,LPPublic2).

ajout_pred_public(P,LPPublic,[P|LPPublic]).




:- public pred_name_to_gvar_name/3.

pred_name_to_gvar_name(F,N,GVar):-
	number_atom(N,An),
	atom_concat(F,'/',F1),
	atom_concat(F1,An,GVar).




:- public create_exec_name/2.

create_exec_name(NoPredExec,PredExec):-
	number_atom(NoPredExec,ANo),
	atom_concat('$exec_',ANo,PredExec).




        % definition d'operateurs pour FD

:- op(700,xfx,in), op(690,xf,no_opt2),
   op(650,yfx,:),  op(600,yfx,&), op(550,xfx,..).

:- op(700,xfx,[#=,#\=,#<,#<=,#>,#>=]).

