/*-------------------------------------------------------------------------*/
/* Prolog To Wam Compiler                INRIA Rocquencourt - CLoE Project */
/* C Run-time                                           Daniel Diaz - 1994 */
/*                                                                         */
/* Machine Dependent Features - Header file                                */
/*                                                                         */
/* machine.h                                                               */
/*-------------------------------------------------------------------------*/

/*---------------------------------*/
/* Machine Type (for configure.c)  */
/*---------------------------------*/

#ifdef CONFIGURE

#   if defined(sparc)

#      define M_MACHINE            "sparc"
#      define M_sparc

#   elif defined(sun) && (defined(mc68000) || defined(mc68020))

#      define M_MACHINE            "sun3"
#      define M_sun3

#   elif defined(__mips__) && defined(sony_news)

#      define M_MACHINE            "sony_news"
#      define M_sony_news

#   elif defined(__mips__) && defined(ultrix)

#      define M_MACHINE            "dec_ultrix"
#      define M_dec_ultrix

#   endif

#endif




/*---------------------------------*/
/* Label and Goto Definitions      */
/*---------------------------------*/

#if defined(M_sony_news) || defined(M_dec_ultrix)

#   define M_Asm_Label1(name)      #name
#   define M_Asm_Label(name)       M_Asm_Label1(name)

#else

#   define M_Asm_Label1(name)      "_"#name
#   define M_Asm_Label(name)       M_Asm_Label1(name)

#endif




#define M_Direct_Goto(fct)         {fct(); return;}

#define M_Indirect_Goto(p_fct)     {(* ((void (*)()) p_fct))();return;}




/*---------------------------------*/
/* Register Definitions            */
/*---------------------------------*/

#if defined(M_sparc) && !defined(NO_REGS)

#    define M_USED_REGS            {"g1","g2","g3","g4","g5","g6","g7",0}


#    define Lib_CallD               (* ((double (*)()) Lib_Call))

     int    Lib_Call();

#    define Lib0(f)                 Lib_Call(f)
#    define Lib1(f,a1)              Lib_Call(f,a1)
#    define Lib2(f,a1,a2)           Lib_Call(f,a1,a2)
#    define Lib3(f,a1,a2,a3)        Lib_Call(f,a1,a2,a3)
#    define Lib4(f,a1,a2,a3,a4)     Lib_Call(f,a1,a2,a3,a4)
#    define Lib5(f,a1,a2,a3,a4,a5)  Lib_Call(f,a1,a2,a3,a4,a5)


#    define LibD0(f)                Lib_CallD(f)               
#    define LibD1(f,a1)             Lib_CallD(f,a1)            
#    define LibD2(f,a1,a2)          Lib_CallD(f,a1,a2)         
#    define LibD3(f,a1,a2,a3)       Lib_CallD(f,a1,a2,a3)      
#    define LibD4(f,a1,a2,a3,a4)    Lib_CallD(f,a1,a2,a3,a4)   
#    define LibD5(f,a1,a2,a3,a4,a5) Lib_CallD(f,a1,a2,a3,a4,a5)

#ifdef MACHINE

       int global_save_g1;
       int global_save_g2;
       int global_save_g3;
       int global_save_g4;
       int global_save_g5;
       int global_save_g6;
       int global_save_g7;

#else

extern int global_save_g1;
extern int global_save_g2;
extern int global_save_g3;
extern int global_save_g4;
extern int global_save_g5;
extern int global_save_g6;
extern int global_save_g7;

#endif

#    define M_Save                                                          \
    {                                                                       \
     register int g1 asm("g1");                                             \
     register int g2 asm("g2");                                             \
     register int g3 asm("g3");                                             \
     register int g4 asm("g4");                                             \
     register int g5 asm("g5");                                             \
     register int g6 asm("g6");                                             \
     register int g7 asm("g7");                                             \
     global_save_g1=g1;                                                     \
     global_save_g2=g2;                                                     \
     global_save_g3=g3;                                                     \
     global_save_g4=g4;                                                     \
     global_save_g5=g5;                                                     \
     global_save_g6=g6;                                                     \
     global_save_g7=g7;                                                     \
    }

#    define M_Restore                                                       \
    {                                                                       \
     register int g1 asm("g1");                                             \
     register int g2 asm("g2");                                             \
     register int g3 asm("g3");                                             \
     register int g4 asm("g4");                                             \
     register int g5 asm("g5");                                             \
     register int g6 asm("g6");                                             \
     register int g7 asm("g7");                                             \
     g1=global_save_g1;                                                     \
     g2=global_save_g2;                                                     \
     g3=global_save_g3;                                                     \
     g4=global_save_g4;                                                     \
     g5=global_save_g5;                                                     \
     g6=global_save_g6;                                                     \
     g7=global_save_g7;                                                     \
    }




#else

#    define M_USED_REGS            {0}

#    define Lib0(f)                 f()
#    define Lib1(f,a1)              f(a1)
#    define Lib2(f,a1,a2)           f(a1,a2)
#    define Lib3(f,a1,a2,a3)        f(a1,a2,a3)
#    define Lib4(f,a1,a2,a3,a4)     f(a1,a2,a3,a4)
#    define Lib5(f,a1,a2,a3,a4,a5)  f(a1,a2,a3,a4,a5)

#    define LibD0(f)                f()
#    define LibD1(f,a1)             f(a1)
#    define LibD2(f,a1,a2)          f(a1,a2)
#    define LibD3(f,a1,a2,a3)       f(a1,a2,a3)
#    define LibD4(f,a1,a2,a3,a4)    f(a1,a2,a3,a4)
#    define LibD5(f,a1,a2,a3,a4,a5) f(a1,a2,a3,a4,a5)

#    define M_Save

#    define M_Restore


#endif




/*---------------------------------*/
/* Stacks Management               */
/*---------------------------------*/

#if defined(M_sparc)

#   define M_USE_MMAP
#   define M_MMAP_HIGH_ADR         0x0ffff000
#   define M_Check_Stacks()

#elif defined(M_sun3) || defined(M_dec_ultrix)

#   define M_USE_SHM
#   define M_SHM_HIGH_ADR          0x0ffff000
#   define M_Check_Stacks()

#else

#   define M_USE_MALLOC
    void   M_Check_Stacks(void);

#endif




#define M_SECURITY_MARGIN          128                      /* in WamWords */
#define M_MAGIC                    0x12345678




/*---------------------------------*/
/* Mul, Div and Rem                */
/*---------------------------------*/

#ifdef M_sparc

    double fmod(double x,double y);

#   define M_Mul(x,y)   ((int) ((double) (x) * (y)))
#   define M_Div(x,y)   ((int) ((double) (x) / (y)))
#   define M_Mod(x,y)   ((x) - M_Mul(M_Div((x),(y)),(y)))

#else

#   define M_Mul(x,y)   ((x) * (y))
#   define M_Div(x,y)   ((x) / (y))
#   define M_Mod(x,y)   ((x) % (y))

#endif




/*---------------------------------*/
/* Miscellaneous (compatibility)   */
/*---------------------------------*/

#ifndef M_sparc

#   define strdup(s)  strcpy(malloc(strlen(s)),s)

#endif




/*---------------------------------*/
/* Function Prototypes             */
/*---------------------------------*/
void      M_Allocate_Stacks     (void);
