/*-------------------------------------------------------------------------*/
/* Prolog to Wam Compiler               INRIA Rocquencourt - ChLoE Project */
/* C Run-time                                           Daniel Diaz - 1994 */
/*                                                                         */
/* Prolog/Wam Debugger - Header file                                       */
/*                                                                         */
/* debugger.h                                                              */
/*-------------------------------------------------------------------------*/
#include "bool.h"

/*---------------------------------*/
/* Constants                       */
/*---------------------------------*/

/*---------------------------------*/
/* Type Definitions                */
/*---------------------------------*/

/*---------------------------------*/
/* Global Variables                */
/*---------------------------------*/

/*---------------------------------*/
/* Function Prototypes             */
/*---------------------------------*/

void      Init_Debugger         (void);
Bool      Debug_Set_Mode        (AtomInf *mode);
AtomInf  *Debug_Get_Mode        (void);

Bool      Debug_Clause          (void);
Bool      Debug_Body            (void);
Bool      Debug_Call            (char *name,int arity,Bool local);
Bool      Debug_Proceed         (void);
Bool      Debug_Fail            (void);

Bool      Debug_Pred            (char *name,int arity);
Bool      Debug_Sub_Pred        (char *name,int arity);
Bool      Debug_Retry           (void);

Bool      Debug_Wam_Inst        (char *format,...);

void      Debug_Display_Infos   (void);
void      Debug_Display_Mode    (void);
void      Debug_Display_Leashing(void);
void      Debug_Display_Exact   (void);
Bool      Debug_Add_Leash_Mode  (AtomInf *leash_mode);
void      Debug_Add_Spy_Point   (AtomInf *atom,int arity);

void      Debug_Remove_Spy_Point(AtomInf *atom,int arity);
