/*-------------------------------------------------------------------------*/
/* Prolog to Wam Compiler               INRIA Rocquencourt - ChLoE Project */
/* Version 1.0  -  C Run-time                           Daniel Diaz - 1991 */
/* Extended to FD Constraints (July 1992)                                  */
/*                                                                         */
/* Built-In: FD mathematical predicates                                    */
/*                                                                         */
/* fd_math.pl                                                              */
/*-------------------------------------------------------------------------*/

:- public 'min(x,y)=z'/3, 'max(x,y)=z'/3, '|x-y|=z'/3.


'min(x,y)=z'(X,Y,Z):-
	'x>=y'(X,Z),
	'x>=y'(Y,Z),
	Z in min(X) .. max(X) : min(Y) .. max(Y)  no_opt2.




'max(x,y)=z'(X,Y,Z):-
	'x>=y'(Z,X),
	'x>=y'(Z,Y),
	Z in min(X) .. max(X) : min(Y) .. max(Y)  no_opt2.




'|x-y|=z'(X,Y,Z):-
	X in min(Y) + min(Z) .. max(Y) + max(Z) :
	     min(Y) - max(Z) .. max(Y) - min(Z),
	Y in min(X) + min(Z) .. max(X) + max(Z) :
	     min(X) - max(Z) .. max(X) - min(Z),
	Z in min(X) - max(Y) .. max(X) - min(Y) :
	     min(Y) - max(X) .. max(Y) - min(X).




	/* Non linear equations management */

:- public 'xx=y'/2, 'xy=z'/3.

'xx=y'(X,Y):-
	X in 'Sqrt_Ceil'(min(Y))..'Sqrt_Floor'(max(Y)),
	Y in min(X)*min(X)..max(X)*max(X).




'xy=z'(X,Y,Z):-
        X in div0_ceil(min(Z),max(Y))..div0_floor(max(Z),min(Y)),
        Y in div0_ceil(min(Z),max(X))..div0_floor(max(Z),min(X)),
        Z in min(X)*min(Y)..max(X)*max(Y) no_opt2.




	/* Linear equations management */

:- public 'x=y'/2, 'x<>y'/2, 'x>=y'/2, 'x>y'/2, '|x-y|=z'/3.


'x=y'(X,Y):- 
	X in min(Y) .. max(Y),
	Y in min(X) .. max(X).




'x<>y'(X,Y):-
	X in -{val(Y)},
	Y in -{val(X)}.




'x>=y'(X,Y):-
	X in min(Y) .. infinity,
	Y in 0      .. max(X).





'x>y'(X,Y):-
	X in min(Y)+1 .. infinity,
	Y in 0        .. max(X)-1.




% per 1

:- public 'ax=y'/3, 'x+y=z'/3.


'ax=y'(A,X,Y):-
	X in min(Y) / A .. max(Y) // A,
	Y in min(X) * A .. max(X) *  A.




'x+y=z'(X,Y,Z):-
	X in min(Z) - max(Y) .. max(Z) - min(Y),
	Y in min(Z) - max(X) .. max(Z) - min(X),
	Z in min(X) + min(Y) .. max(X) + max(Y).




% per 2

:- public 'x+c=y'/3, 'ax+c=y'/4, 'ax+y=z'/4.


'x+c=y'(X,C,Y):-
	X in min(Y) - C .. max(Y) - C,
	Y in min(X) + C .. max(X) + C.




'ax+c=y'(A,X,C,Y):-
	X in (min(Y) - C) / A .. (max(Y) - C) // A,
	Y in  min(X)*A + C    ..  max(X)*A + C.




'ax+y=z'(A,X,Y,Z):-
	X in (min(Z) - max(Y)) / A .. (max(Z) - min(Y)) // A,
	Y in  min(Z) - max(X)*A    ..  max(Z) - min(X)*A,
	Z in  min(X)*A + min(Y)    ..  max(X)*A + max(Y).




% per 3

:- public 'ax+by=z'/5, 'x+y+c=z'/4, 'ax+y+c=z'/5, 'ax+by+c=z'/6,
	           'x+y+z=t'/4, 'ax+y+z=t'/5, 'ax+by+z=t'/6.


'ax+by=z'(A,X,B,Y,Z):-
	X in  (min(Z) - B*max(Y)) / A ..  (max(Z) - B*min(Y)) // A,
	Y in  (min(Z) - A*max(X)) / B ..  (max(Z) - A*min(X)) // B,
	Z in A*min(X) + B*min(Y)      .. A*max(X) + B*max(Y).




'x+y+c=z'(X,Y,C,Z):-
	X in min(Z) - max(Y) - C .. max(Z) - min(Y) - C,
	Y in min(Z) - max(X) - C .. max(Z) - min(X) - C,
	Z in min(X) + min(Y) + C .. max(X) + max(Y) + C.




'ax+y+c=z'(A,X,Y,C,Z):-
	X in  (min(Z) -   max(Y) - C)/A ..  (max(Z) -   min(Y) - C)//A,
	Y in   min(Z) - A*max(X) - C    ..   max(Z) - A*min(X) - C,
	Z in A*min(X) +   min(Y) + C    .. A*max(X) +   max(Y) + C.




'ax+by+c=z'(A,X,B,Y,C,Z):-
	X in  (min(Z) - B*max(Y) - C)/A ..  (max(Z) - B*min(Y) - C)//A,
	Y in  (min(Z) - A*max(X) - C)/B ..  (max(Z) - A*min(X) - C)//B,
	Z in A*min(X) + B*min(Y) + C    .. A*max(X) + B*max(Y) + C.




'x+y+z=t'(X,Y,Z,T):-
	X in min(T) - max(Y) - max(Z) .. max(T) - min(Y) - min(Z),
	Y in min(T) - max(X) - max(Z) .. max(T) - min(X) - min(Z),
	Z in min(T) - max(X) - max(Y) .. max(T) - min(X) - min(Y),
	T in min(X) + min(Y) + min(Z) .. max(X) + max(Y) + max(Z).




'ax+y+z=t'(A,X,Y,Z,T):-
	X in  (min(T) -   max(Y) - max(Z)) / A .. 
	      (max(T) -   min(Y) - min(Z)) // A,

	Y in   min(T) - A*max(X) - max(Z) ..  
	       max(T) - A*min(X) - min(Z),

	Z in   min(T) - A*max(X) - max(Y) .. 
	       max(T) - A*min(X) - min(Y),

	T in A*min(X) +   min(Y) + min(Z) .. 
	     A*max(X) +   max(Y) + max(Z).




'ax+by+z=t'(A,X,B,Y,Z,T):-
	X in  (min(T) - B*max(Y) -   max(Z)) /  A .. 
	      (max(T) - B*min(Y) -   min(Z)) // A,

	Y in  (min(T) - A*max(X) -   max(Z)) /  B ..  
	      (max(T) - A*min(X) -   min(Z)) // B,

	Z in   min(T) - A*max(X) - B*max(Y) .. 
	       max(T) - A*min(X) - B*min(Y),

	T in A*min(X) + B*min(Y) +   min(Z) .. 
	     A*max(X) + B*max(Y) +   max(Z).

