;;  $Id: load.lisp,v 1.3 1993/01/22 10:27:15 anjo Exp $
;;  
;;  File	load.lisp
;;  Part of	PCE/Lisp interface
;;  Author	Anjo Anjewierden, anjo@swi.psy.uva.nl
;;  Purpose	Loading of PCE/Lisp interface files
;;  Works with	PCE 4.4, SCL 3.0, SCL 4.0, LispWorks 3.1
;;  
;;  Notice	Copyright (c) 1992  University of Amsterdam
;;  
;;  History	01/03/91  (Created)
;;  		01/12/92  (Last Modified)


;;  ------------------------------------------------------
;;  Directives
;;  ------------------------------------------------------

(in-package "USER")


(unless (find-package "PCE")
	(make-package "PCE"))


(in-package "PCE")

#+LISPWORKS (use-package "FOREIGN")
#+LISPWORKS (use-package "USER")


;;  ------------------------------------------------------
;;  Customisation of the environment
;;  ------------------------------------------------------

(defconstant *host-directory*
  #+LISPWORKS "/usr/local/LispWorks/"
  #+LUCID     "/swi02/lisp/"
  "Directory in which Lisp implementation resides")

(defconstant *pce-directory* "/staff/jan/src/xpce/"
  "Directory in which PCE installation resides")

(defconstant *pce-saved-state*
  #+LISPWORKS "./xpcelw"
  #+LUCID     "./xpcelisp4-anjo"
  "Name of the PCE/Lisp saved state")

(defconstant *pce-symbol-file*       "/staff/anjo/src/PCELisp/pce-image.o"
  "Name of the file containing the PCE binaries; required for PCE C stack trace")


;;  ------------------------------------------------------
;;  Control of the environment
;;  ------------------------------------------------------

(defconstant *pce-host*
  #+LISPWORKS "lispworks"
  #+LUCID     "lucid"
  "Name of the host language; used to generate file names")

(defconstant *pce-image* *pce-symbol-file*)

(defconstant *pce-lisp-sources*
  (list "pce-macros"			; Macros defined by PCE/Lisp
	"pce-representation"		; Representation of PCE objects
	(concatenate 'string "install-"	; Host specific installation file
		       *pce-host*)
	(concatenate 'string "host-"	; Host specific foreign functions
		       *pce-host*)
	"pce-api"			; Application programmer's interface
	"pce-initialisation"		; Initialisation (e.g. PCE/Lisp classes)
	"pce-user-defined-classes"	; Syntax for PCE user defined classes
	"pce-goodies"))			; Convenience functions


;;  ------------------------------------------------------
;;  Control of compilation
;;  ------------------------------------------------------

#+LUCID
(proclaim '(optimize (speed 3)
		     (compilation-speed 0)
		     (safety 0)))


;;  ------------------------------------------------------
;;  Some assistance with version control
;;  ------------------------------------------------------

(pushnew :PCE *features*)
(pushnew :XPCE *features*)

#+LUCID (pushnew :STATIC-LISP-SYMBOLS *features*)


;;  ------------------------------------------------------
;;  Loading the PCE/Lisp interface
;;  ------------------------------------------------------

(dolist (file *pce-lisp-sources*)
	(load file))
