/*  $Id: pce_drag_and_drop.pl,v 1.3 1993/12/20 12:32:27 jan Exp $

    Part of XPCE
    Designed and implemented by Anjo Anjewierden and Jan Wielemaker
    E-mail: jan@swi.psy.uva.nl

    Copyright (C) 1993 University of Amsterdam. All rights reserved.
*/

:- module(drag_and_drop, []).
:- use_module(library(pce)).
:- require([ ignore/1
	   ]).

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Define a gesture that allows to `drag-and-drop' objects.  The target on
which to drop should understand the method ->drop, which will be called
with the dropped graphical as an argument.  If may also implement
->preview_drop, which will be called to provide visual feedback of the
drop that will take place when the button is released here.
- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

:- pce_begin_class(drag_and_drop_gesture, gesture,
		   "Drag and drop command-gesture").

variable(target,	graphical*,	get, "Drop target").

initiate(G, Ev:event) :->
	"Change the cursor"::
	get(Ev, receiver, Gr),
	get(G, cursor, Gr, Ev, Cursor),
	send(G, cursor, Cursor).


cursor(_G, Gr, _Ev, Cursor:cursor) :<-
	"Create cursor from the graphical"::
	get(Gr, size, size(W, H)),
	new(HotSpot, point(W/2, H/2)),
	send(Gr, pointer, HotSpot),
%	get(Ev, position, Gr, HS),
%	get(HS, clone, HotSpot),
	new(BM, image(@nil, W, H)),
	send(BM, draw_in, Gr, point(0,0)),
	send(BM, or, image('cross.bm'), point(HotSpot?x-8, HotSpot?y-8)),
	new(Cursor, cursor(@nil, BM, @default, HotSpot)).


drag(G, Ev:event) :->
	"Find possible ->drop target"::
	(   get(Ev, inside_sub_window, Frame),
	    get(Ev, inside_sub_window, Frame, Window),
	    get(Window, find, Ev,
		or(G?target == @arg1,
		   message(G, target, @arg1)),
		_Gr)
	->  true
	;   send(G, target, @nil)
	).


target(G, Gr:graphical*) :->
	"Make the given object the target"::
	(   Gr == @nil
	;   get(Gr, is_displayed, @on),
	    send(Gr, has_send_method, drop)
	),
	ignore((get(G, target, Old),
		send(Old, has_send_method, preview_drop),
		send(Old, preview_drop, @nil))),
	(   send(Gr, has_send_method, preview_drop)
	->  send(Gr, preview_drop, @event?receiver)
	;   true
	),
	send(G, slot, target, Gr).
		

terminate(G, Ev:event) :->
	"->drop to <-target"::
	send(G, cursor, @default),
	get(G, slot, target, Target),
	(   Target == @nil
	->  true
	;   send(G, target, @nil),
	    send(Target, focus_cursor, watch),
	    ignore(send(Target, drop, Ev?receiver)),
	    send(Target, focus_cursor, @nil)
	).

:- pce_end_class.
