
:- module(y_scrollable,[y_scrollable/2]).

:- ensure_loaded(library(ytoolkit)).
:- ensure_loaded(library(edipo)).

y_scrollable(createNotify,Name) :-
	get_window_attr(Name,height,H),
	set_attr(Name,h,H),
	set_attr(Name,pos,0).
y_scrollable(configureNotify(_,_,_,H,_),Name) :-
	get_attr(Name,h,OH),
	get_attr(Name,pos,Pos0),
	get_attr(Name,part,P),

	Pos is integer(Pos0/OH*H),
	Eh is integer(P*H),

	set_attr(Name,h,H),
	set_attr(Name,pos,Pos),
	clear,
	frectangle(1,Pos,13,Eh).

y_scrollable(expose(0),Name) :-
	get_attr(Name,pos,Pos),
	get_attr(Name,part,P),
	get_attr(Name,h,H),
	Eh is integer(P*H),
	clear,
	frectangle(1,Pos,13,Eh).

y_scrollable(buttonPress(1,_,_),Name) :-
	get_attr(Name,part,P),
	get_attr(Name,pos,Pos0),
	get_attr(Name,h,H),
	Eh is integer(P*H),
	TPos is Pos0+Eh,
	(TPos+Eh<H -> Pos=TPos ; Pos is H-Eh),
	set_attr(Name,pos,Pos),
	clear,
	frectangle(1,Pos,13,Eh),
	call_back(Name,callback(Pos,P,H)).
y_scrollable(buttonPress(2,_,Y),Name) :-
	position(Name,Y,Pos,P,H),
	call_back(Name,callback(Pos,P,H)).
y_scrollable(buttonPress(3,_,_),Name) :-
	get_attr(Name,part,P),
	get_attr(Name,pos,Pos0),
	get_attr(Name,h,H),
	Eh is integer(P*H),
	TPos is Pos0-Eh,
	(TPos>0 -> Pos=TPos ; Pos=0),
	set_attr(Name,pos,Pos),
	clear,
	frectangle(1,Pos,13,Eh),
	call_back(Name,callback(Pos,P,H)).

y_scrollable(motionNotify(_,Y),Name) :-
	get_attr(Name,moving,true),
	position(Name,Y,_,_,_).

y_scrollable(buttonRelease(2,_,_),Name) :-
	unset_attr(Name,moving),
	get_attr(Name,part,P),
	get_attr(Name,pos,Pos),
	get_attr(Name,h,H),
	call_back(Name,callback(Pos,P,H)).


position(Name,Y,Pos,P,H) :-
	get_attr(Name,part,P),
	get_attr(Name,h,H),
	Eh is integer(P*H),
	TPos is Y-Eh>>1,
	(TPos+Eh=<H, TPos>=0 -> 
		Pos=TPos
	;
		(TPos+Eh>H -> Pos is H-Eh; otherwise),
		(TPos<0 -> Pos=0; otherwise)
	),
	set_attr(Name,pos,Pos),
	clear,
	set_attr(Name,moving,true),
	frectangle(1,Pos,13,Eh).

