%-----------------------------------------------------------------------%
%									%
%			Edipo - sicstus/quintus version			%
%									%
%						August 90		%
%						Ze' Paulo Leal		%
%						Universidade do Porto	%
%									%
%-----------------------------------------------------------------------%
%									%
%	file :		draw.pl						%
%	purpose : 	edipo drawing primitives			%
%	creation	90/08/01					%
%	last changes :	90/08/01					%
%	bugs :								%
%	commennts :	very incomplete					%
%									%
%-----------------------------------------------------------------------%

%% Flush control

:- dynamic if_flush/1.

dont_flush :- do_flush, asserta((if_flush(_) :- !)).

do_flush :- retract((if_flush(_) :- !)), fail.
do_flush.

flush :- recorded('$display','$display'(_,D),_), x_flush(D), fail.
flush.

if_flush(DY) :- x_flush(DY).

%% primitives

line(X1,X2,Y1,Y2) :-
	recorded('$window','$window'(_,DY,WD,GC),_), !,
	x_draw_line(DY,WD,GC,X1,X2,Y1,Y2),
	if_flush(DY).


rectangle(X1,X2,Width,Height) :-
	recorded('$window','$window'(_,DY,WD,GC),_), !,
	x_draw_rectangle(DY,WD,GC,X1,X2,Width,Height),
	if_flush(DY).


frectangle(X1,X2,Width,Height) :-
	recorded('$window','$window'(_,DY,WD,GC),_), !,
	x_fill_rectangle(DY,WD,GC,X1,X2,Width,Height),
	if_flush(DY).

crectangle(X1,X2,Width,Height) :-
	recorded('$window','$window'(_,DY,WD,_),_), !,
	x_clear_area(DY,WD,X1,X2,Width,Height,0),
	if_flush(DY).


circle(X,Y,R) :-
	recorded('$window','$window'(_,DY,WD,GC),_), !,
	L is R<<1,
	XR is X-R,
	YR is Y-R,
	x_draw_arc(DY,WD,GC,XR,YR,L,L,0,23040),
	if_flush(DY).

fcircle(X,Y,R) :-
	recorded('$window','$window'(_,DY,WD,GC),_), !,
	L is R<<1,
	XR is X-R,
	YR is Y-R,
	x_fill_arc(DY,WD,GC,XR,YR,L,L,0,23040),
	if_flush(DY).

arc(X,Y,W,H,A,B) :-
	recorded('$window','$window'(_,DY,WD,GC),_), !,
	x_draw_arc(DY,WD,GC,X,Y,W,H,A,B),
	if_flush(DY).

farc(X,Y,W,H,A,B) :-
	recorded('$window','$window'(_,DY,WD,GC),_), !,
	x_fill_arc(DY,WD,GC,X,Y,W,H,A,B),
	if_flush(DY).

poly(L) :-
	recorded('$window','$window'(_,DY,WD,GC),_), !,
	set_points(L,0,N),
	x_my_polygon(DY,WD,GC,0,N),
	if_flush(DY).

fpoly(L) :-
	recorded('$window','$window'(_,DY,WD,GC),_), !,
	set_points(L,0,N),
	x_my_polygon(DY,WD,GC,1,N),
	if_flush(DY).


set_points([],N,N) :- x_my_init_poly(N).
set_points([(X,Y)|R],I,N) :-
	J is I+1,
	set_points(R,J,N),
	x_my_poly_point(X,Y).

/* The Sound of Drawing */

bell(Percent) :-
	((Percent>= -100, Percent=<100) ->
	    recorded('$window','$window'(_,Display,_,_),_), !,
	    'XBell'(Display,Percent),
	    if_flush(Display)
	;
	    format('[[edipo: bell percent ~w not in [-100,100] ]]~n',Percent)
	).


