

/* chars top level */

:- use_module(matrix).
:- use_module(play_reversi).


:- recorda(color,white,_).
:- recorda(level,heuristic,_).
:- recorda(execution,repeat_fail,_).

go :- 
	recorded(color,C,_),
	recorded(level,A,_),
	recorded(execution,Exec,_),
	new_tab(T),
	go_exec(Exec,T,C,A).

go_exec(recursive,T,C,A) :- go_rec(T,C,A).
go_exec(repeat_fail,T,C,A) :- 
	(recorded(table,_,R),erase(R),fail;true), % debugging
	go_repf(T,C,A).

go_rec(T,C,A) :-
	a_move(T,C,A,NT),
	go_rec(NT,C,A).

go_repf(T,C,A) :-
	recorda(table,T,_), 
	recorded(table,PT,R), 
		(a_move(PT,C,A,NT) -> true),
		recordz(table,NT,_), 
		erase(R), 
	fail.


new_tab(T4) :-
	make_matrix(8,8,T0),
	change_matrix(T0,4,4,white,T1),
	change_matrix(T1,4,5,black,T2),
	change_matrix(T2,5,4,black,T3),
	change_matrix(T3,5,5,white,T4).

a_move(T,C,A,MT) :-
	show_move(T),
	read_move(I,J),
	(make_move(T,I,J,C,NT) -> 
		otherwise
	; 	
		message('Invalid move'), fail
	),
	show_move(NT),
	message('Tinking ...'),
	other(C,O),
	(choose_position(A,NT,O,MT) ->
		otherwise
	;
		message('no move available')
	).

	
read_move(I,J) :- 
	repeat, 
	write('Your move '),
	read(T),
	(T=abort -> abort; T=(I,J), check(I,J)).

check(I,J) :- 
	(	(integer(I), 1=<I, I=<8, integer(J), 1=<J, J=<8) ->
		otherwise
	;
 		message('Wrong syntax'), 
		message('	enter "LINE, COLUMN."  to make a move'),
		message('	or "abort." to exit.'),
		fail
	).

show_move(T) :-	
	vspace(7), 
	show_matrix(T),
	static_evaluation(T,V,B,P),
	nl, Diff is B-P,
	write((static_value=V,white=B,black=P,diff=Diff)), 
	vspace(7).


vspace(N) :- (N=0 -> true; nl, M is N-1, vspace(M)).


show_matrix([C|R]) :- 
	show_columns(C),
	show_matrix([C|R],1),
	show_columns(C).

show_columns(R) :- tab(21), show_columns(R,1).

show_columns([],_) :- nl.
show_columns([_|R],I) :- 
	tab(1), write(I),
	NI is I+1,
	show_columns(R,NI).

show_matrix([],_).
show_matrix([E|T],I) :- 
	tab(20),
	write(I),
	show_matrix_line(E),
	write(I), nl,
	NI is I+1,
	show_matrix(T,NI).
show_matrix_line([]) :- write('|').
show_matrix_line([E|T]) :- write('|'), show(E), show_matrix_line(T).

show(empty) :- write(.).
show(white) :- write(o).
show(black) :- write(x).



message(M) :- write(M), nl.
