/*----------------------------------------------------------------------*
*									*
*			Edipo - sicstus/quintus version			*
*									*
*						August 90		*
*						Ze' Paulo Leal		*
*						Universidade do Porto	*
*									*
*-----------------------------------------------------------------------*
*									*
*	file :		gc.c						*
*	purpose : 	mostly text and font handling function		*
*	creation	90/08/03					*
*	last changes :	91/12/18					*
*	bugs :		invalid attributes values are not trapped	*
*	comments :					 		*
*									*
*----------------------------------------------------------------------*/

#include "callx.h"
#include "attr.h"

XGCValues gc_values;
unsigned long  gc_mask=0L;

x_set_gc_int_attr(attr,value) 
     unsigned long int attr;
     long value;
{
  atom_entry *an;
  
  GCAtomSearch(an,attr);
  gc_mask |= an->mask;
  switch(an->mask)
    {
    case GCLineWidth:		gc_values.line_width= value; break;
/*      
    case GCPlaneMask:
    case GCForeground:
    case GCBackground:
      break;
*/
    }
}


x_set_gc_atom_attr(attr,value) 
     unsigned long int attr,value;
{
  atom_entry *an,*va;
  int v;
  
  GCAtomSearch(an,attr);
  GCValAtomSearch(va,value);
  if(va==NULL)
    ErrorHandler("invalid attribute value",ABORT_AFTER_ERROR);      
  v=va->mask;
  
  gc_mask |= an->mask;
  switch(an->mask)
    {
    case GCFunction:	gc_values.function=v;	break;
    case GCLineStyle:	gc_values.line_style=v;	break;
    case GCCapStyle:	gc_values.cap_style=v;	break;
    case GCJoinStyle:	gc_values.join_style=v;	break;
    case GCFillStyle:	gc_values.fill_style=v;	break;
    case GCFillRule:	gc_values.fill_rule=v;	break;
    case GCArcMode:	gc_values.arc_mode=v;	break;
    }
}


x_my_change_gc(display,gc)
     Display	*display;
     GC 	gc;
     
{
  if(gc_mask != 0L)
    XChangeGC(display,gc,gc_mask,&gc_values);

  XFlush(display);
  gc_mask=0L;
}
