/*----------------------------------------------------------------------*
*									*
*			Edipo - sicstus/quintus version			*
*									*
*						August 90		*
*						Ze' Paulo Leal		*
*						Universidade do Porto	*
*									*
*-----------------------------------------------------------------------*
*									*
*	file :		event.c						*
*	purpose : 	event handling functions			*
*	creation	90/08/03					*
*	last changes :	90/08/03					*
*	bugs :								*
*	commennts :	destroy events cannot be generated  		*
*									*
*----------------------------------------------------------------------*/

#include "callx.h"


unsigned long int
  keyPress_atom,
  keyRelease_atom,
  buttonPress_atom,
  buttonRelease_atom,
  motionNotify_atom,
  enterNotify_atom,
  leaveNotify_atom,
  expose_atom,
  visibilityNotify_atom,
  createNotify_atom,
  configureNotify_atom,
  destroyNotify_atom,
  mapNotify_atom,
  unmapNotify_atom;

my_select_input(my_disp,my_win)
     Display *my_disp;
     Window my_win;
{
  XSelectInput(my_disp,my_win,
	       ExposureMask|
	       StructureNotifyMask |
	       SubstructureNotifyMask |
	       VisibilityChangeMask |
	       ButtonReleaseMask |
	       ButtonPressMask | 
	       EnterWindowMask |
	       LeaveWindowMask |
	       PointerMotionMask |
	       ButtonMotionMask |
	       
	       KeyPressMask |  
	       KeyReleaseMask |
	       KeymapNotify
	       );
}


static char keybuf[32];

my_next_event(no_block,display,my_window,event_type,arg0,arg1,arg2,arg3,arg4,arg5)
     long int no_block;
     Display *display;
     Window *my_window;
     long int *event_type;
     char **arg0;
     long int *arg1, *arg2, *arg3, *arg4, *arg5;
{
  XEvent event;

  *my_window  = 0L;
  *event_type = nil_atom;
  *arg0 = "[]",
  *arg1 = *arg2 = *arg3 = *arg4 = *arg5 =  (long int) nil_atom;
  
  while(TRUE)
    {

      if(no_block && XPending(display) == 0)
	  return 1;

      XNextEvent(display,&event );
      switch(event.type) 
	{
	  /*** Keyboard events ***/
	case KeyPress:
	  {
	    KeySym mykey;
	    XComposeStatus cs;
	    int count;
	    
	    *event_type = keyPress_atom;
	    *my_window = event.xkey.window;
	    count = XLookupString((XKeyEvent*)&event,*arg0,STRSIZE,&mykey,&cs);
	    (*arg0)[count] = '\0';
	    
	    *arg1 = (long int) mykey;
	    *arg2 = (long int) event.xkey.x;
	    *arg3 = (long int) event.xkey.y;
	    return 1;
	  }
	case KeyRelease:
	  {
	    KeySym mykey;
	    XComposeStatus cs;
	    int count;
	    
	    *event_type = keyRelease_atom;
	    *my_window = event.xkey.window;
 	    *arg0 = keybuf;	/* avoid writing to string constant */
	    count = XLookupString((XKeyEvent*)&event,*arg0,STRSIZE,&mykey,&cs);
	    (*arg0)[count] = '\0';
	    
	    *arg1 = (long int) mykey;
	    *arg2 = (long int) event.xkey.x;
	    *arg3 = (long int) event.xkey.y;
	    return 1;
	  }
	  /*** Mouse motion events ***/
	case ButtonPress:
	  *event_type = buttonPress_atom;
	  *my_window = event.xkey.window;
	  *arg1=(long int) event.xbutton.button;
	  *arg2=(long int) event.xbutton.x;
	  *arg3=(long int) event.xbutton.y;
	  return 1;
	case ButtonRelease:
	  *event_type = buttonRelease_atom;
	  *my_window = event.xkey.window;
	  *arg1=(long int) event.xbutton.button;
	  *arg2=(long int) event.xbutton.x;
	  *arg3=(long int) event.xbutton.y;
	  return 1;
	case MotionNotify:
	  *event_type = motionNotify_atom;
	  *my_window = event.xkey.window;
	  *arg1=event.xmotion.x;
	  *arg2=event.xmotion.y;
	  return 1;
	  /*** Window crossing events ***/
	case EnterNotify:
	  *event_type = enterNotify_atom;
	  *my_window = event.xcrossing.window;
	  return 1;
	case LeaveNotify:
	  *event_type = leaveNotify_atom;
	  *my_window = event.xcrossing.window;
	  return 1;
	  /*** ImputFocus events (not requested) ***/
	  /*** Keymap state modification event ***/  
	case MappingNotify:		/* this event is not passed to EDIPO */
	  XRefreshKeyboardMapping((XMappingEvent*) &event);
	  break;
	  /*** Expose  events ***/
	case Expose:
	  *event_type = expose_atom;
	  *my_window = event.xexpose.window;
	  *arg1=event.xexpose.count;
	  return 1;  
	case GraphicsExpose:
	case NoExpose:
	  break;
	  /*** Structure con.. events (not requested) ***/
	  /*** Window State modification events ***/
	case VisibilityNotify:
	  {
	    *event_type = visibilityNotify_atom;
	    *my_window = event.xvisibility.window;
	    switch(event.xvisibility.state)
	    {
	    case VisibilityUnobscured: *arg0="unobscured"; break;
	    case VisibilityPartiallyObscured: *arg0="partiallyObscured";break;
	    case VisibilityFullyObscured: *arg0="fullyObscured"; break;
	    }
	    return 1;
	  }
	case CreateNotify:
	  *event_type = createNotify_atom;
	  *my_window = event.xcreatewindow.window;
	  return 1;
	case ConfigureNotify:
	  *event_type = configureNotify_atom;
	  *my_window = event.xconfigure.window;
	  *arg1 = event.xconfigure.x;
	  *arg2 = event.xconfigure.y;
	  *arg3 = event.xconfigure.width;
	  *arg4 = event.xconfigure.height;
	  *arg5 = event.xconfigure.border_width;
	  return 1;
	case DestroyNotify:
	  break;
/*	  *event_type = destroyNotify_atom;
	  *my_window = event.xdestroywindow.window;
	  return 1;
*/
	case MapNotify:
	  *event_type = mapNotify_atom;
	  *my_window = event.xdestroywindow.window;
	  return 1;
	case UnmapNotify:
	  *event_type = unmapNotify_atom;
	  *my_window = event.xdestroywindow.window;
	  return 1;

	case ReparentNotify:
	case CirculateNotify:
	case GravityNotify:
	  break;

	  /*** Color map state modification events (not requested) ***/
	  /*** Client comunication events (not requested) ***/
	}
      
    }
}
