

:- module(reversi,[reversi/0]).


:- use_module(library(ytoolkit)).
:- use_module(play_reversi).

:- use_module(library('widgets/popup'),toggle_menu_item/2).

:- write('*** try this one ***			?- reversi.'),nl,nl,nl.



default(bkg_pixmap,[
			"#   ",
			"   #",
			" #  ",
			"  # "
			]).
default(cursor,circle).
default(line_width,4).
default(tab,T0).
default(color,white).
default(against,computer).
default(play_first,false).
default(aginst,computer).
default(trace,true).
default(level,minimax(1)).
default(level_item,).

default(square,25).
default(board,8).


reversi :- reversi(8,25).
reversi(N,S) :- 
sub_widgets(W) :-
%	select_widget_name(reversi,W),
	get_attr(W,board,N),
	get_attr(W,square,S),
	
	matrix:make_matrix(N,N,T0),
	new_widget(no_class,[
		bkg_pixmap=[
			"#   ",
			"   #",
			" #  ",
			"  # "
			],
	draw(rectangle(S,33+S,N*S,N*S)),
	new_widget(popup,[
		parent=W,
		x=5,
		y=5,
		text=' Control ',
		menu=menu(
			item(' Exit to Prolog ',ytoolkit:exit_loop)
			)
	],M1),
	new_widget(popup,[
		parent=W,
		x=M1~x+M1~width,
		y=5,
		text=' Game ',
		menu=menu(
			item(' New Game ',new_game(W)),
			item(' Play First ',play_first(W,M2,2)),
			item(' Play With White ',change_color(W,M2,3)),
			item(' Against Human ',against(W,M2,4))
		)
	],M2),
	new_widget(popup,[
		parent=W,
		x=M2~x+M2~width,
		y=5,
		text=' Level ',
		menu=menu(
			item(' Naive ',set_level(naive,W,M3,1)),
			item(' Analisys 1 ',set_level(minimax(1),W,M3,2)),
			item(' Analisys 2 ',set_level(minimax(2),W,M3,3)),
			item(' Analisys 3 ',set_level(minimax(3),W,M3,4)),
			item(' Analisys 4 ',set_level(minimax(4),W,M3,5)),
			item(' Analisys 5 ',set_level(minimax(5),W,M3,6))
		)
	],M3),
	toggle_menu_item(M3,2),

	current_font(['6x13',*],Font),
	row(N,N,S,W),
	new_widget(_,[
		parent=W,
		x=10*S,
		y=30+S,
		width=W~width-11*S,
		height=W~height-(30+S)-20,
		border=1,
		border_pixel=black,
		font=Font
	],Board),
	change_widget(_,[board=Board],W),

	new_game(W),

	loop.


row(R,N,S,W) :- (R=0 -> otherwise ; column(R,N,S,W), R1 is R-1, row(R1,N,S,W)).

column(R,C,S,W) :- (C=0 -> otherwise
	;
		new_piece(R,C,S,W),
		C1 is C-1,
		column(R,C1,S,W)
	).


new_piece(R,C,S,W) :- 
	new_widget(piece,[
		parent=W,
		x=C*S,
		y=30+R*S,
		border=2,
		width=S-1,
		height=S-1,
		status=empty,
		row=R,
		column=C,	
		callback(B)=change(B,P,W)
	],P),
	change_widget(_,[piece(R,C)=P],W).

/* callbacks */


change(B,P,W) :-
	change_widget(_,[cursor=watch],W),
	current_widget(_,[tab=T,color=C],W),
	current_widget(piece,[row=PR,column=PC],P),
	(make_move(T,PR,PC,C,NT) ->
		change_widget(_,[tab=NT,color=C],W),
		show_tab(T,NT,W),
		reply(NT,C,W)
	;
%		message(W,'Invalid Move')
		bell(100),bell(100),bell(100)
	),
	change_widget(_,[cursor=circle],W).

reply(T,C,W) :-
	current_widget(_,[against=A,level=L],W),
	other_color(C,O),
	reply(A,L,T,C,W,O).

reply(human,_,_T,_C,W,O) :-	change_widget(_,[color=O],W).
reply(computer,Level,T,C,W,O) :-
	(choose_position(Level,T,O,NT) ->
		current_widget(_,[tab=OT],W),
		show_tab(OT,NT,W),
		change_widget(_,[tab=NT,color=C],W)
	;
		message(W,'No move available')
	).

other_color(white,black).
other_color(black,white).

message(W,M) :-
	TW=300,
	TH=80,
	new_widget(dialog_box,[
		parent=W,
		x=(W~width-TW)/2,
		y=(W~height-TH)/2,
		width=TW,
		height=TH,
		font='9x15bold'
	],D),
	draw(writeterm(20,50,M)),
	new_widget(button,[
		parent=D
		,x=width-120
		,y=30
		,text='Ok'
		,callback=cont(D)
		],_).	

cont(D) :- kill_widget(_,[],D).

/* menu callbacks */

set_level(L,W,M,I) :-
	current_widget(_,[level_item=O],W),
	toggle_menu_item(M,O),
	toggle_menu_item(M,I),
	change_widget(_,[level_item=I,level=L],W).
	
new_game(W) :-
	change_widget(_,[cursor=watch],W),
	current_widget(_,[tab=OT,play_first=PF,color=C],W),
	new_tab(T),
	change_widget(_,[tab=T],W),
	show_tab(OT,T,W),
	(PF=false ->	otherwise; reply(T,C,W)),
	change_widget(_,[cursor=circle],W).

play_first(W,M,I) :-
	toggle_menu_item(M,I),
	(current_widget(_,[play_first=true],W) ->
		change_widget(_,[play_first=false],W)
	;
		change_widget(_,[play_first=true],W)
	).

against(W,M,I) :-
	toggle_menu_item(M,I),
	(current_widget(_,[against=computer],W) ->
		change_widget(_,[against=human],W)
	;
		change_widget(_,[against=computer],W)
	).



change_color(W,M,I) :-
	toggle_menu_item(M,I),
	(current_widget(_,[color=white],W) ->
		change_widget(_,[color=black],W)
	;
		change_widget(_,[color=white],W)
	).

/* utils */


show_tab(OT,T,W) :- 
	show_tab(OT,T,W,1),
	current_widget(_,[board=B],W),
	static_evaluation(T,V,Wh,Bl), Diff is Wh - Bl,
	clear_widget(B),
	draw(B,writeterm(5,30,diff=Diff)),
	draw(B,writeterm(5,60,eval=V)).

show_tab([],[],W,_I).
show_tab([OR|OC],[R|C],W,I) :- 
	show_tab(OR,R,W,I,1),
	NI is I+1,
	show_tab(OC,C,W,NI).

show_tab([],[],_W,_I,_J).
show_tab([OE|OC],[E|C],W,I,J) :- 
	(OE=E -> otherwise
	;
		current_widget(_,[piece(I,J)=P],W),
		change_widget(_,[status=E],P)
	),
	NJ is J+1,
	show_tab(OC,C,W,I,NJ).


trace(_T,_L) :- !.
trace(T,L) :- 
	W=reversi,
	(current_widget(_,[trace=true,board=B,tab=OT],W) ->
		show_tab(OT,T,W),
		change_widget(_,[tab=T],reversi),
		draw(B,writeterm(5,90,level=L)),
		new_widget(button,[
			parent=B,
			x=5,
			y=120,
			width=B~width-12,
			text='Go on',
			callback=go_on(Bt)
		],Bt),
		dispatch:inner_loop
			
	;
		otherwise
	).

go_on(Bt) :- exit_loop, kill_widget(_,[],Bt).
