
:- module(matrix,[
	make_matrix/3,	% make_matrix(I,J,T) makes matrix T[I,J]
	matrix/4,	% matrix(T,I,J,P) unifies P with T[I,J]
	change_matrix/5	% change_matrix(T,I,J,P,NT) NT:=T, NT[I,J]:=P 
]).



% makes matrix T with dim. I J
make_matrix(I,J,T) :- 
	(I=0 -> T=[]
	;
		T=[R|C],
		make_matrix(J,R),
		NI is I-1,
		make_matrix(NI,J,C)
	).
make_matrix(J,T) :- 
	(J=0 -> T=[]
	;
		T=[ empty |C],
		NJ is J-1,
		make_matrix(NJ,C)
	).



matrix([E|T],I,J,P) :- (I=1 -> matrix(E,J,P) ; NI is I-1, matrix(T,NI,J,P)).
matrix([E|T],J,P) :- (J=1 -> P=E ; NJ is J-1, matrix(T,NJ,P)).


change_matrix([E|T],I,J,P,[NE|NT]) :- 
	(I=1 -> 
		change_matrix(E,J,P,NE),
		NT=T
	; 	
		NE=E,
		NI is I-1, 
		change_matrix(T,NI,J,P,NT)
	).
change_matrix([E|T],J,P,[NE|NT]) :- 
	(J=1 -> 
		NE=P,
		NT=T
	; 	
		NE=E,
		NJ is J-1, 
		change_matrix(T,NJ,P,NT)
	).


