% as per Sterling & Shapiro page 222 & 223
%
% move blocks from one position to another
%%%%%%%%%%%%%%
% demo bit

test_plan( Name, Plan) :-
	initial_state( Name, I),
	final_state( Name, F),
	change_state( I, F, Plan).


initial_state( test, [ on( a, b), on( b, p), on( c, r)]).

final_state( test, [on(a, b), on( b, c), on( c, r)]).


block( a).
block( b).
block( c).

place( p).
place( q).
place( r).
%%%%%%%%%%%%%%%%%

% change_state( +State1, +State2, -PathToGetThere)
% 
change_state( State1, State2, Plan) :-
	transform( State1, State2, [State1], Plan).

transform( State, State, Visited, []).
transform( State1, State2, Visited, [Action|Actions]) :-
	choose_action( Action, State1, State2),
	update( Action, State1, State),
	\+( member( State, Visited)),
	transform( State, State2, [State|Visited], Actions).

choose_action( Action, State1, State2) :-
	suggest( Action, State2),
	legal_action( Action, State1).
choose_action( Action, State1, State2) :-
	legal_action( Action, State1).

suggest( to_place( X, Y, Z), State) :-
	member( on( X, Z), State),
	place( Z).
suggest( to_block( X, Y, Z), State) :-
	member( on( X, Z), State),
	block( Z).

legal_action( to_place( Block, Y, Place), State) :-
	on( Block, Y, State),
	clear( Block, State),
	place( Place),
	clear( Place, State).
legal_action( to_block( Block1, Y, Block2), State) :-
	on( Block1, Y, State),
	clear( Block1, State),
	block( Block2),
	\+( ==( Block1, Block2)),
	clear( Block2, State).


clear( X, State) :- 
	\+( member( on( A, X), State)).

on( X, Y, State) :-
	member( on( X, Y), State).
	

update( to_block( X, Y, Z), State, State1) :-
	substitute( on( X, Y), on( X, Z), State, State1).
update( to_place( X, Y, Z), State, State1) :-
        substitute( on( X, Y), on( X, Z), State, State1).

substitute( X, Y, [], []).
substitute( X, Y, [X|Rest], [Y|Rest]).
substitute( X, Y, [Z|Rest], [Z|Rest1]) :-
	\+( ==( Z, X)),
	substitute( X, Y, Rest, Rest1).


