% simple forward chaining interpreter ( see Bratko Chapt 14)
% operators if, then etc. already built in to NU-Prolog..
%
% just type forward at the prompt
%
:- op( 800, fx, if1).
:- op(700, xfx, then1).
:- op(300, xfy, or1).
:- op(200, xfy, and1).


forward :-
	new_derived_fact( P), !,
	write( 'Derived: '),
	write( P), nl,
	assert( fact( P)),
	forward ; write( 'No more facts'), nl.

new_derived_fact( Concl) :-
	if1 Cond then1 Concl,
	 \+ fact(Concl),
	composed_fact( Cond).

composed_fact( Cond) :-
	fact( Cond).

composed_fact( Cond1 and1 Cond2) :-
	composed_fact( Cond1),
	composed_fact( Cond2).	

composed_fact(Cond1 or1 Cond2) :-
	composed_fact( Cond1) ;
	composed_fact( Cond2).


% rules etc.
:- dynamic fact/1.

fact( hall_wet).
fact( bathroom_dry).
fact( window_closed).


if1
	hall_wet and1 kitchen_dry
then1
	leak_in_bathroom.

if1
	hall_wet and1 bathroom_dry
then1
	problem_in_kitchen.

if1
	window_closed or1 no_rain
then1
	no_water_from_outside.

if1 
	problem_in_kitchen and1 no_water_from_outside
then1
	leak_in_kitchen.





