% simple backward chaining interpreter using operators
% if, then or and and are already defined in NU-Prolog
% with different precedences... and won't work properly
%
% to test, make a call to
% is_true( leak_in_kitchen).

:- op( 800, fx, if1).
:- op(700, xfx, then1).
:- op(300, xfy, or1).
:- op(200, xfy, and1).


is_true( P) :-
	fact( P).

is_true( P) :-
	if1 Condition then1 P,
	is_true( Condition).

is_true( P1 and1 P2) :-
	is_true( P1),
	is_true( P2).

is_true( P1 or1 P2) :-
	is_true( P1) ; is_true( P2).


%%%%%%% rules %%%%%%%%%%%%%

% facts
fact( hall_wet).
fact( bathroom_dry).
fact( window_closed).


if1
	hall_wet and1 kitchen_dry
then1
	leak_in_bathroom.

if1
	hall_wet and1 bathroom_dry
then1
	problem_in_kitchen.

if1
	window_closed or1 no_rain
then1
	no_water_from_outside.

if1 
	problem_in_kitchen and1 no_water_from_outside
then1
	leak_in_kitchen.





