.\"     Start of program display
.de AA
.ID
.ft C
.lg 0
.ps -1
.vs -1
..

.\"     End of program display
.de ZZ
.ps +1
.vs +1
.lg
.ft R
.DE
..

.nr PS 11
.nr VS 13
.ps 11
.vs 13

.TL
A Useful Extension to
.br
Prolog's DCG Notation
.br
.sp 1
User Manual
.AU
Peter Van Roy
vanroy@ernie.berkeley.edu
.AI
Computer Science Division
University of California
Berkeley, CA 94720
.AE
.NH
\s+1Introduction\s-1
.PP
This manual describes a preprocessor for Prolog that
adds an arbitrary number of arguments
to a predicate
without increasing the size of the
source code.
The hidden arguments are of two kinds:
.IP (1)
Accumulators, useful for results that are calculated
incrementally in many predicates.
An accumulator expands into two additional arguments
per predicate.
.IP (2)
Passed arguments, used to pass global information to many predicates.
A passed argument expands into a single 
additional argument per predicate.
.LP
The preprocessor
has been tested under C-Prolog and Quintus Prolog.
It is being used by the author
in program development,
and is believed to be relatively bug-free.
However, it is still being refined and extended.
The most recent version
is available by
anonymous ftp to arpa.berkeley.edu or by contacting the author.
Please let me know if you find any bugs.
Comments and suggestions for improvements are welcome.
.KF
.TS
box,center,tab(#);
c s
c c
l lw(4i).
Table 1 \(em Expansion rules for the preprocessor
=
Body goal#Action
_
\fC{Goal}\fR#T{
Don't expand any hidden arguments of \fCGoal\fR.
T}
_
\fCGoal\fR#T{
Expand all of the hidden parameters of \fCGoal\fR  that
are also in the head.
Those hidden parameters not in the head
are given default values.
T}
_
\fCGoal:L\fR#T{
If \fCGoal\fR  has no hidden arguments
then force the expansion
of all arguments in \fCL\fR  in
the order given.
If \fCGoal\fR  has hidden arguments
then expand all of them,
using the contents of \fCL\fR  to override
the expansion.
\fCL\fR  is either
a term of the form \fCAcc\fR, \fCAcc(Left,Right)\fR,
\fCPass\fR, \fCPass(Value)\fR, or a list of such terms.
When present,
the arguments \fCLeft\fR, \fCRight\fR, and
.ft C
Value\fR override the default values of arguments
not in the head.
T}
_
\fCList:Acc\fR#T{
Accumulate a list of terms in the accumulator \fCAcc\fR.
T}
_
\fCList\fR#T{
Accumulate a list of terms in the accumulator \fCdcg\fR.
T}
_
\fCX/Arg\fR#T{
Unify \fCX\fR  with the left term for
the accumulator or passed argument \fCArg\fR.
T}
_
\fCAcc/X\fR#T{
Unify \fCX\fR  with the right term for accumulator \fCAcc\fR.
T}
_
\fCX/Acc/Y\fR#T{
Unify \fCX\fR  with the left and \fCY\fR  with
the right term for the accumulator \fCAcc\fR.
T}
_
\fCinsert(X,Y):Acc\fR#T{
Insert the arguments \fCX\fR  and \fCY\fR  into the chain
implementing the accumulator \fCAcc\fR.
This is useful when the value of the accumulator
changes radically because
\fCX\fR  and \fCY\fR  may be the arguments of
an arbitrary relation.
T}
_
\fCinsert(X,Y)\fR#T{
Insert the arguments \fCX\fR  and \fCY\fR  into the chain
implementing the accumulator \fCdcg\fR .
This inserts the difference list \fCX-Y\fR  into
the accumulated list.
T}
.TE
.KE
.NH
\s+1Using the preprocessor\s-1
.PP
The preprocessor is implemented in the file \fCaccumulator.pl\fR.
It must be consulted or compiled before the programs that use it.
In Prologs that conform to the Edinburgh standard,
such as C-Prolog or Quintus Prolog,
the user-defined predicate \fCterm_expansion/2\fR  is
called when consulting or compiling each clause that is read.
With this hook the use of the preprocessor is transparent.
.PP
Clauses to be expanded are of the form \fC(Head-->>Body)\fR
where \fCHead\fR  and
.ft C
Body\fR  are the head and body of the clause.
The head is always expanded with all of its hidden arguments.
Table 1 summarizes the expansion rules for body goals.
In the table, \fCGoal\fR  denotes any goal in a clause body,
\fCAcc\fR  denotes an accumulator,
\fCPass\fR  denotes a passed argument,
and \fCArg\fR  denotes either
an accumulator or a passed argument.
Hidden arguments
of body goals that are not in the head
have default values which can be overridden.
For compatibility with DCG notation
the accumulator \fCdcg\fR  is available by default.
If-then-else is not handled in this version.
.PP
The preprocessor
assumes the existence of a database of information about
the hidden parameters and the predicates to be expanded.
Three relations are recognized: a declaration
for each predicate, each accumulator, and each passed argument.
These relations can be
put at the beginning of each file (in which case their scope is the file)
or stored in a separate file
that is consulted first (in which case their scope is the whole program).
.LP
A short example gives a flavor of what the preprocessor does:
.AA
% Declare the accumulator 'castor':
acc_info(castor, _, _, _, true).

% Declare the passed argument 'pollux':
pass_info(pollux).

% Declare three predicates using these hidden arguments:
pred_info(p, 1, [castor,pollux]).
pred_info(q, 1, [castor,pollux]).
pred_info(r, 1, [castor,pollux]).

% The program:
p(X) -->> Y is X+1, q(Y), r(Y).
.ZZ
This example declares one accumulator, one passed argument,
and three predicates using them.
The program consists of a single clause.
The preprocessor is used as follows:
(bold-face denotes user input)
.AA
% \f(CBcprolog\fC
C-Prolog version 1.5
| ?- \f(CB['accumulator.pl'].\fC
accumulator.pl consulted 9780 bytes 1.7 sec.

yes
| ?- \f(CB['example.pl'].\fC
example.pl consulted 668 bytes 0.25 sec.

yes
| ?-
.ZZ
Now the predicate \fCp(X)\fR  has been expanded.
We can see what it looks like with the \fClisting\fR  command:
.AA
| ?- \f(CBlisting(p)\fC.
 
p(X, S1, S3, P) :- Y is X+1, q(Y, S1, S2, P), r(Y, S2, S3, P).
.ZZ
(Variable names have been changed for clarity.)
The arguments \fCS1\fR, \fCS2\fR, and \fCS3\fR,
which implement the accumulator \fCcastor\fR, are
chained together.
The argument \fCP\fR  implements the passed argument.
It is added as an extra argument to each predicate.
.PP
In object-oriented terminology
the declarations of hidden parameters correspond
to classes with a single method
defined for each.
Declarations of predicates specify the inheritance
of the predicate from multiple classes,
namely each hidden parameter.
.NH
\s+1Declarations\s-1
.NH 2
Declaration of the predicates
.LP
Predicates are declared with facts of the following form:
.AA
pred_info(Name, Arity, List)
.ZZ
The predicate \fCName/Arity\fR  has the hidden parameters given
in \fCList\fR.
The parameters are added in the order 
given by \fCList\fR and
their names must be atoms.
.NH 2
Declaration of the accumulators
.LP
Accumulators are declared with facts in one of two forms.
The short form is:
.AA
acc_info(Acc, Term, Left, Right, Joiner)
.ZZ
The long form is:
.AA
acc_info(Acc, Term, Left, Right, Joiner, LStart, RStart)
.ZZ
.LP
In most cases the short form gives sufficient information.
It declares the accumulator \fCAcc\fR, which must be an atom,
along with the
accumulating function, \fCJoiner\fR, and its arguments
\fCTerm\fR,
the term to be accumulated,
and \fCLeft\fR & \fCRight\fR, the variables used in chaining.
.PP
The long form of \fCacc_info\fR  is useful in more complex programs.
It contains two additional arguments,
\fCLStart\fR  and \fCRStart\fR, that are used
to give default
starting values for an accumulator occurring in a body goal
that does not occur in the head.
The starting values are given to the unused accumulator
to ensure that it will execute correctly even though its value is not used.
Care is needed to give correct values for \fCLStart\fR  and \fCRStart\fR.
For DCG-like list accumulation
both may remain unbound.
.PP
Two conventions are used
for the two variables used in chaining
depending on which direction the accumulation is done.
For forward accumulation, \fCLeft\fR  is the input
and \fCRight\fR  is the output.
For reverse accumulation, \fCRight\fR  is the input
and \fCLeft\fR  is the output.
.LP
To see how these declarations work,
consider the following program:
.AA
% Example illustrating the difference between
% forward and reverse accumulation:

% Declare the accumulators:
acc_info(fwd, T, In, Out, Out=[T|In]).   % Forward accumulator.
acc_info(rev, T, Out, In, Out=[T|In]).   % Reverse accumulator.

% Declare the predicates using them:
pred_info(flist, 1, [fwd]).
pred_info(rlist, 1, [rev]).

% flist(N, [], List) creates the list [1, 2, ..., N]
flist(0) -->> [].
flist(N) -->> N>0, [N]:fwd, N1 is N-1, flist(N1).

% rlist(N, List, []) creates the list [N, ..., 2, 1]
rlist(0) -->> [].
rlist(N) -->> N>0, [N]:rev, N1 is N-1, rlist(N1).
.ZZ
This defines two accumulators \fCfwd\fR  and \fCrev\fR  that
both accumulate lists, but in different directions.
The joiner of both accumulators is the unification \fCOut=[T|In]\fR,
which adds \fCT\fR  to the head of the list \fCIn\fR  and
creates the list \fCOut\fR.
In accumulator \fCfwd\fR  the
output \fCOut\fR  is the left argument
and the input \fCIn\fR  is the right argument.
This builds the list in ascending order.
Switching the arguments,
as in
the accumulator \fCrev\fR, builds the list in reverse.
A sample execution gives these results:
.AA
| ?- flist(10, [], List).

List = [1,2,3,4,5,6,7,8,9,10]

yes
| ?- rlist(10, List, []).

List = [10,9,8,7,6,5,4,3,2,1]

yes
| ?-
.ZZ
.LP
If the joining function is not reversible then
the accumulator can only be used in one direction.
For example,
the accumulator \fCadd\fR  with declaration:
.AA
acc_info(add, I, In, Out, Out is I+In).
.ZZ
It can only be used as a forward accumulator.
Attempting to use it in reverse
results in an error because the argument \fCIn\fR  of
the joiner is uninstantiated.
The reason for this is that the predicate \fCis/2\fR  is not
pure logic: it requires the expression in its right-hand side to
be ground.
.NH 2
Declaration of the passed arguments
.LP
Passed arguments are declared as facts in one of two forms.
The short form is:
.AA
pass_info(Pass)
.ZZ
The long form is:
.AA
pass_info(Pass, PStart)
.ZZ
.LP
In most cases the short form is sufficient.
It declares a passed argument \fCPass\fR, that
must be an atom.
The long form also contains the starting value \fCPStart\fR
that is used to give a default value for
a passed argument in a body goal
that does not occur in the head.
Most of the time this situation does not occur.
.NH
\s+1Tips and techniques\s-1
.PP
Usually there will be
one clause of \fCpred_info\fR  for each predicate in the program.
If the program becomes very large, the number of clauses of
\fCpred_info\fR  grows accordingly and can
become difficult to keep consistent.
In that case it is useful to remember that a single
\fCpred_info\fR  clause can summarize many facts.
For example, the following declaration:
.AA
pred_info(_, _, List).
.ZZ
gives all predicates
the hidden parameters in \fCList\fR.
This keeps programming simple regardless of the
number of hidden parameters.
.NH
\s+1Acknowledgements\s-1
.PP
This research was partially sponsored by the Defense Advanced Research
Projects Agency (DoD) and monitored by Space & Naval Warfare Systems
Command under Contract No. N00014-88-K-0579.
.NH
\s+1References\s-1
.LP
[Abramson 1984]
.IP
H. Abramson,
\*QDefinite Clause Translation Grammars,\*U
.I
Proc. 1984 International Symposium on Logic Programming,
.R
1984,
pp 233-240.
.LP
[Clocksin & Mellish 1981]
.IP
W.F. Clocksin and C.S. Mellish,
\*QProgramming in Prolog,\*U
.I
Springer-Verlag,
.R
1981.
.LP
[O'Keefe 1988]
.IP
R. A. O'Keefe,
\*QPractical Prolog for Real Programmers,\*U
.I
Tutorial 8,
Fifth International Conference Symposium on Logic Programming,
Aug. 1988.
.LP
[Pereira 1981]
.IP
F. Pereira,
\*QExtraposition Grammars,\*U
.I
American Journal of Computational Linguistics,
.R
1981,
vol. 7, no. 4, pp 243-255.
.LP
[Pereira & Shieber 1987]
.IP
F. Pereira and S. Shieber,
\*QProlog and Natural-Language Analysis,\*U
.I
CSLI Lecture Notes,
.R
1987,
no. 10.
.LP
[Pereira & Warren 1980]
.IP
F. Pereira and D.H.D. Warren,
\*QDefinite Clause Grammars for Language Analysis\(emA Survey of the
Formalism and a Comparison with Augmented Transition Networks,\*U
.I
Journal of Artificial Intelligence,
.R
1980,
vol. 13, no. 3, pp 231-278.
.LP
[Sterling & Shapiro 1986]
.IP
L. Sterling and E. Shapiro,
\*QThe Art of Prolog,\*U
.I
MIT Press,
.R
1986.
